/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.zookeeper.services;

import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.zookeeper.services.ZooKeeperContainer;
import org.apache.camel.test.infra.zookeeper.services.ZooKeeperInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InfraService(service=ZooKeeperInfraService.class, description="Zookeeper is a server for highly reliable distributed coordination of cloud applications", serviceAlias={"zookeeper"})
public class ZooKeeperLocalContainerInfraService
implements ZooKeeperInfraService,
ContainerService<ZooKeeperContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperLocalContainerInfraService.class);
    private final ZooKeeperContainer container;

    public ZooKeeperLocalContainerInfraService() {
        this(LocalPropertyResolver.getProperty(ZooKeeperLocalContainerInfraService.class, (String)"zookeeper.container"));
    }

    public ZooKeeperLocalContainerInfraService(String imageName) {
        this.container = this.initContainer(imageName);
    }

    public ZooKeeperLocalContainerInfraService(ZooKeeperContainer container) {
        this.container = container;
    }

    protected ZooKeeperContainer initContainer(String imageName) {
        if (imageName == null) {
            return new ZooKeeperContainer();
        }
        return new ZooKeeperContainer(imageName);
    }

    public void registerProperties() {
        System.setProperty("zookeeper.connection.string", this.getConnectionString());
    }

    public void initialize() {
        LOG.info("Trying to start the ZooKeeper container");
        this.container.start();
        this.registerProperties();
        LOG.info("ZooKeeper instance running at {}", (Object)this.getConnectionString());
    }

    public void shutdown() {
        LOG.info("Stopping the ZooKeeper container");
        this.container.stop();
    }

    public ZooKeeperContainer getContainer() {
        return this.container;
    }

    @Override
    public String getConnectionString() {
        return this.container.getConnectionString();
    }
}

