/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.weaviate.services;

import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.weaviate.services.WeaviateInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.weaviate.WeaviateContainer;

@InfraService(service=WeaviateInfraService.class, description="Weaviate Vector Database", serviceAlias={"weaviate"})
public class WeaviateLocalContainerInfraService
implements WeaviateInfraService,
ContainerService<WeaviateContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(WeaviateLocalContainerInfraService.class);
    private final WeaviateContainer container;

    public WeaviateLocalContainerInfraService() {
        this(LocalPropertyResolver.getProperty(WeaviateLocalContainerInfraService.class, (String)"weaviate.container"));
    }

    public WeaviateLocalContainerInfraService(String imageName) {
        this.container = this.initContainer(imageName);
    }

    public WeaviateLocalContainerInfraService(WeaviateContainer container) {
        this.container = container;
    }

    protected WeaviateContainer initContainer(final String imageName) {
        class TestInfraWeaviateContainer
        extends WeaviateContainer {
            public TestInfraWeaviateContainer(boolean fixedPort) {
                super(DockerImageName.parse((String)string).asCompatibleSubstituteFor("semitechnologies/weaviate"));
                this.withStartupTimeout(Duration.ofMinutes(3L));
                if (fixedPort) {
                    this.addFixedExposedPort(8087, 8080);
                    this.addFixedExposedPort(50051, 50051);
                }
            }
        }
        return new TestInfraWeaviateContainer(ContainerEnvironmentUtil.isFixedPort(this.getClass()));
    }

    public void registerProperties() {
        System.setProperty("weaviate.endpoint.url", this.getWeaviateEndpointUrl());
        System.setProperty("weaviate.endpoint.host", this.getWeaviateHost());
        System.setProperty("weaviate.endpoint.port", String.valueOf(this.getWeaviatePort()));
    }

    public void initialize() {
        LOG.info("Trying to start the Weaviate container");
        this.container.start();
        this.registerProperties();
        LOG.info("Weaviate instance running at {}", (Object)this.getWeaviateEndpointUrl());
    }

    public void shutdown() {
        LOG.info("Stopping the Weaviate container");
        this.container.stop();
    }

    public WeaviateContainer getContainer() {
        return this.container;
    }

    @Override
    public String getWeaviateEndpointUrl() {
        return this.container.getHttpHostAddress();
    }

    @Override
    public String getWeaviateHost() {
        URL url = null;
        try {
            url = new URL("http://" + this.container.getHttpHostAddress());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return url.getHost();
    }

    @Override
    public int getWeaviatePort() {
        URL url = null;
        try {
            url = new URL("http://" + this.container.getHttpHostAddress());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return url.getPort();
    }
}

