/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.weaviate.services;

import org.apache.camel.test.infra.common.services.InfrastructureService;
import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.weaviate.services.WeaviateLocalContainerInfraService;
import org.apache.camel.test.infra.weaviate.services.WeaviateRemoteInfraService;
import org.apache.camel.test.infra.weaviate.services.WeaviateService;

public final class WeaviateServiceFactory {
    private WeaviateServiceFactory() {
    }

    public static SimpleTestServiceBuilder<WeaviateService> builder() {
        return new SimpleTestServiceBuilder("weaviate");
    }

    public static WeaviateService createService() {
        return (WeaviateService)WeaviateServiceFactory.builder().addLocalMapping(WeaviateLocalContainerService::new).addRemoteMapping(WeaviateRemoteService::new).build();
    }

    public static WeaviateService createSingletonService() {
        return (WeaviateService)WeaviateServiceFactory.builder().addLocalMapping(() -> new SingletonWeaviateService(new WeaviateLocalContainerService(), "weaviate")).build();
    }

    public static class SingletonWeaviateService
    extends SingletonService<WeaviateService>
    implements WeaviateService {
        public SingletonWeaviateService(WeaviateService service, String name) {
            super((InfrastructureService)service, name);
        }

        @Override
        public String getWeaviateEndpointUrl() {
            return ((WeaviateService)this.getService()).getWeaviateEndpointUrl();
        }

        @Override
        public String getWeaviateHost() {
            return ((WeaviateService)this.getService()).getWeaviateHost();
        }

        @Override
        public int getWeaviatePort() {
            return ((WeaviateService)this.getService()).getWeaviatePort();
        }
    }

    public static class WeaviateLocalContainerService
    extends WeaviateLocalContainerInfraService
    implements WeaviateService {
    }

    public static class WeaviateRemoteService
    extends WeaviateRemoteInfraService
    implements WeaviateService {
    }
}

