/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.tensorflow.serving.services;

import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.tensorflow.serving.services.TensorFlowServingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class TensorFlowServingLocalContainerService
implements TensorFlowServingService,
ContainerService<GenericContainer<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(TensorFlowServingLocalContainerService.class);
    public static final int GRPC_PORT = 8500;
    public static final int REST_PORT = 8501;
    private final GenericContainer<?> container = this.initContainer();

    protected GenericContainer<?> initContainer() {
        boolean isArm64 = System.getProperty("os.arch").equals("aarch64");
        String imageName = LocalPropertyResolver.getProperty(TensorFlowServingLocalContainerService.class, (String)"tensorflow.serving.container");
        if (isArm64) {
            return new GenericContainer(DockerImageName.parse((String)imageName)).withExposedPorts(new Integer[]{8500, 8501}).withCopyFileToContainer(MountableFile.forClasspathResource((String)"testdata/saved_model_half_plus_two_cpu"), "/bitnami/model-data").withEnv("TENSORFLOW_SERVING_MODEL_NAME", "half_plus_two").waitingFor((WaitStrategy)Wait.forListeningPorts((int[])new int[]{8500, 8501}));
        }
        return new GenericContainer(DockerImageName.parse((String)imageName)).withExposedPorts(new Integer[]{8500, 8501}).withCopyFileToContainer(MountableFile.forClasspathResource((String)"testdata/saved_model_half_plus_two_cpu"), "/models/half_plus_two").withEnv("MODEL_NAME", "half_plus_two").waitingFor((WaitStrategy)Wait.forListeningPorts((int[])new int[]{8500, 8501}));
    }

    public void registerProperties() {
        System.setProperty("tensorflow.serving.grpc.port", String.valueOf(this.grpcPort()));
        System.setProperty("tensorflow.serving.rest.port", String.valueOf(this.restPort()));
    }

    public void initialize() {
        LOG.info("Trying to start the TensorFlow Serving container");
        this.container.start();
        this.registerProperties();
        LOG.info("TensorFlow Serving instance running at {} and {}", (Object)this.grpcPort(), (Object)this.restPort());
    }

    public void shutdown() {
        LOG.info("Stopping the TensorFlow Serving container");
        this.container.stop();
    }

    public GenericContainer<?> getContainer() {
        return this.container;
    }

    @Override
    public int grpcPort() {
        return this.container.getMappedPort(8500);
    }

    @Override
    public int restPort() {
        return this.container.getMappedPort(8501);
    }
}

