/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.neo4j.services;

import org.apache.camel.test.infra.common.services.InfrastructureService;
import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.neo4j.services.Neo4jLocalContainerInfraService;
import org.apache.camel.test.infra.neo4j.services.Neo4jRemoteInfraService;
import org.apache.camel.test.infra.neo4j.services.Neo4jService;

public final class Neo4jServiceFactory {
    private Neo4jServiceFactory() {
    }

    public static SimpleTestServiceBuilder<Neo4jService> builder() {
        return new SimpleTestServiceBuilder("neo4j");
    }

    public static Neo4jService createService() {
        return (Neo4jService)Neo4jServiceFactory.builder().addLocalMapping(Neo4jLocalContainerService::new).addRemoteMapping(Neo4jRemoteService::new).build();
    }

    public static Neo4jService createSingletonService() {
        return (Neo4jService)Neo4jServiceFactory.builder().addLocalMapping(() -> new SingletonNeo4jService(new Neo4jLocalContainerService(), "neo4j")).build();
    }

    public static class SingletonNeo4jService
    extends SingletonService<Neo4jService>
    implements Neo4jService {
        public SingletonNeo4jService(Neo4jService service, String name) {
            super((InfrastructureService)service, name);
        }

        @Override
        public String getNeo4jDatabaseUri() {
            return ((Neo4jService)this.getService()).getNeo4jDatabaseUri();
        }

        @Override
        public String getNeo4jDatabaseUser() {
            return ((Neo4jService)this.getService()).getNeo4jDatabaseUser();
        }

        @Override
        public String getNeo4jDatabasePassword() {
            return ((Neo4jService)this.getService()).getNeo4jDatabasePassword();
        }
    }

    public static class Neo4jLocalContainerService
    extends Neo4jLocalContainerInfraService
    implements Neo4jService {
    }

    public static class Neo4jRemoteService
    extends Neo4jRemoteInfraService
    implements Neo4jService {
    }
}

