/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.kafka.services;

import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.kafka.services.KafkaService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.utility.DockerImageName;

public class ContainerLocalKafkaService
implements KafkaService,
ContainerService<KafkaContainer> {
    public static final String KAFKA3_IMAGE_NAME = LocalPropertyResolver.getProperty(ContainerLocalKafkaService.class, (String)"kafka3.container");
    public static final String KAFKA2_IMAGE_NAME = LocalPropertyResolver.getProperty(ContainerLocalKafkaService.class, (String)"kafka2.container");
    private static final Logger LOG = LoggerFactory.getLogger(ContainerLocalKafkaService.class);
    private final KafkaContainer kafka;

    public ContainerLocalKafkaService() {
        this.kafka = this.initContainer();
    }

    public ContainerLocalKafkaService(KafkaContainer kafka) {
        this.kafka = kafka;
    }

    protected KafkaContainer initContainer() {
        return new KafkaContainer(DockerImageName.parse((String)System.getProperty("kafka.container", KAFKA3_IMAGE_NAME)).asCompatibleSubstituteFor("apache/kafka")).withEmbeddedZookeeper();
    }

    @Override
    public String getBootstrapServers() {
        return this.kafka.getBootstrapServers();
    }

    public void registerProperties() {
        System.setProperty("kafka.bootstrap.servers", this.getBootstrapServers());
    }

    public void initialize() {
        this.kafka.start();
        this.registerProperties();
        LOG.info("Kafka bootstrap server running at address {}", (Object)this.kafka.getBootstrapServers());
    }

    public void shutdown() {
        LOG.info("Shutting down Kafka container");
        this.kafka.stop();
    }

    public KafkaContainer getContainer() {
        return this.kafka;
    }

    public static ContainerLocalKafkaService kafka2Container() {
        KafkaContainer container = new KafkaContainer(DockerImageName.parse((String)System.getProperty("kafka.container", KAFKA2_IMAGE_NAME)).asCompatibleSubstituteFor("confluentinc/cp-kafka"));
        container = container.withEmbeddedZookeeper();
        return new ContainerLocalKafkaService(container);
    }

    public static ContainerLocalKafkaService kafka3Container() {
        KafkaContainer container = new KafkaContainer(DockerImageName.parse((String)System.getProperty("kafka.container", KAFKA3_IMAGE_NAME)).asCompatibleSubstituteFor("confluentinc/cp-kafka"));
        container = container.withEmbeddedZookeeper();
        return new ContainerLocalKafkaService(container);
    }
}

