/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.kafka.services;

import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.kafka.services.KafkaInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.kafka.KafkaContainer;
import org.testcontainers.utility.DockerImageName;

@InfraService(service=KafkaInfraService.class, description="Apache Kafka, Distributed event streaming platform", serviceAlias={"kafka"})
public class ContainerLocalKafkaInfraService
implements KafkaInfraService,
ContainerService<KafkaContainer> {
    public static final String KAFKA3_IMAGE_NAME = LocalPropertyResolver.getProperty(ContainerLocalKafkaInfraService.class, (String)"kafka3.container");
    private static final Logger LOG = LoggerFactory.getLogger(ContainerLocalKafkaInfraService.class);
    protected KafkaContainer kafka;

    public ContainerLocalKafkaInfraService() {
        this.kafka = this.initContainer();
    }

    public ContainerLocalKafkaInfraService(KafkaContainer kafka) {
        this.kafka = kafka;
    }

    protected KafkaContainer initContainer() {
        return new KafkaContainer(DockerImageName.parse((String)System.getProperty("kafka.container", KAFKA3_IMAGE_NAME)).asCompatibleSubstituteFor("apache/kafka"));
    }

    @Override
    public String getBootstrapServers() {
        return this.kafka.getBootstrapServers();
    }

    public void registerProperties() {
        System.setProperty("kafka.bootstrap.servers", this.getBootstrapServers());
    }

    public void initialize() {
        this.kafka.start();
        this.registerProperties();
        LOG.info("Kafka bootstrap server running at address {}", (Object)this.kafka.getBootstrapServers());
    }

    public void shutdown() {
        LOG.info("Shutting down Kafka container");
        this.kafka.stop();
    }

    public KafkaContainer getContainer() {
        return this.kafka;
    }

    public static ContainerLocalKafkaInfraService kafka3Container() {
        KafkaContainer container = new KafkaContainer(DockerImageName.parse((String)System.getProperty("kafka.container", KAFKA3_IMAGE_NAME)).asCompatibleSubstituteFor("apache/kafka"));
        return new ContainerLocalKafkaInfraService(container);
    }
}

