/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.hashicorp.vault.services;

import java.util.function.Consumer;
import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.hashicorp.vault.services.HashicorpVaultInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@InfraService(service=HashicorpVaultInfraService.class, description="Vault is a tool for securely accessing secrets", serviceAlias={"hashicorp"}, serviceImplementationAlias={"vault"})
public class HashicorpVaultLocalContainerInfraService
implements HashicorpVaultInfraService,
ContainerService<GenericContainer<?>> {
    public static final String CONTAINER_NAME = "hashicorp-vault";
    private static final String DEFAULT_TOKEN = "myToken";
    private static final Logger LOG = LoggerFactory.getLogger(HashicorpVaultLocalContainerInfraService.class);
    private final GenericContainer container;

    public HashicorpVaultLocalContainerInfraService() {
        this(LocalPropertyResolver.getProperty(HashicorpVaultLocalContainerInfraService.class, (String)"hashicorp.vault.container"));
    }

    public HashicorpVaultLocalContainerInfraService(String containerImage) {
        this.container = this.initContainer(containerImage, CONTAINER_NAME);
    }

    public HashicorpVaultLocalContainerInfraService(GenericContainer container) {
        this.container = container;
    }

    protected GenericContainer initContainer(String imageName, String containerName) {
        Logger containerLog = LoggerFactory.getLogger((String)("container." + containerName));
        Slf4jLogConsumer logConsumer = new Slf4jLogConsumer(containerLog);
        return new GenericContainer(imageName).withNetworkAliases(new String[]{containerName}).withEnv("VAULT_DEV_ROOT_TOKEN_ID", DEFAULT_TOKEN).withLogConsumer((Consumer)logConsumer).withExposedPorts(new Integer[]{8200}).waitingFor((WaitStrategy)Wait.forListeningPort()).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Development.*mode.*should.*", (int)1));
    }

    public void registerProperties() {
        System.setProperty("hashicorp.vault.host", this.host());
        System.setProperty("hashicorp.vault.port", String.valueOf(this.port()));
        System.setProperty("hashicorp.vault.token", DEFAULT_TOKEN);
    }

    public void initialize() {
        LOG.info("Trying to start the Hashicorp Vault container");
        this.container.withStartupAttempts(5);
        this.container.start();
        this.registerProperties();
    }

    public void shutdown() {
        LOG.info("Stopping the Hashicorp Vault container");
        this.container.stop();
        System.clearProperty("hashicorp.vault.host");
        System.clearProperty("hashicorp.vault.port");
        System.clearProperty("hashicorp.vault.token");
    }

    public GenericContainer getContainer() {
        return this.container;
    }

    @Override
    public String token() {
        return DEFAULT_TOKEN;
    }

    @Override
    public int port() {
        return this.container.getMappedPort(8200);
    }

    @Override
    public String host() {
        return this.container.getHost();
    }
}

