/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.elasticsearch.services;

import org.apache.camel.test.infra.common.services.TestService;
import org.apache.camel.test.infra.common.services.TestServiceUtil;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public interface ElasticSearchService
extends BeforeAllCallback,
AfterAllCallback,
TestService {
    public int getPort();

    public String getElasticSearchHost();

    default public String getHttpHostAddress() {
        return String.format("%s:%d", this.getElasticSearchHost(), this.getPort());
    }

    default public void beforeAll(ExtensionContext extensionContext) throws Exception {
        TestServiceUtil.tryInitialize((TestService)this, (ExtensionContext)extensionContext);
    }

    default public void afterAll(ExtensionContext extensionContext) throws Exception {
        TestServiceUtil.tryShutdown((TestService)this, (ExtensionContext)extensionContext);
    }
}

