/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.elasticsearch.services;

import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.elasticsearch.services.ElasticSearchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.elasticsearch.ElasticsearchContainer;

public class ElasticSearchLocalContainerService
implements ElasticSearchService,
ContainerService<ElasticsearchContainer> {
    public static final String DEFAULT_ELASTIC_SEARCH_CONTAINER = "docker.elastic.co/elasticsearch/elasticsearch-oss:7.10.2";
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchLocalContainerService.class);
    private static final int ELASTIC_SEARCH_PORT = 9200;
    private final ElasticsearchContainer container;

    public ElasticSearchLocalContainerService() {
        this(System.getProperty("elasticsearch.container", DEFAULT_ELASTIC_SEARCH_CONTAINER));
    }

    public ElasticSearchLocalContainerService(String imageName) {
        this.container = this.initContainer(imageName);
    }

    public ElasticSearchLocalContainerService(ElasticsearchContainer container) {
        this.container = container;
    }

    protected ElasticsearchContainer initContainer(String imageName) {
        return new ElasticsearchContainer(imageName);
    }

    @Override
    public int getPort() {
        return this.container.getMappedPort(9200);
    }

    @Override
    public String getElasticSearchHost() {
        return this.container.getHost();
    }

    @Override
    public String getHttpHostAddress() {
        return this.container.getHttpHostAddress();
    }

    public void registerProperties() {
        System.setProperty("elasticsearch.host", this.getElasticSearchHost());
        System.setProperty("elasticsearch.port", String.valueOf(this.getPort()));
    }

    public void initialize() {
        LOG.info("Trying to start the ElasticSearch container");
        ContainerEnvironmentUtil.configureContainerStartup((GenericContainer)this.container, (String)"elasticsearch.container.startup.attempts", (int)2);
        this.container.start();
        this.registerProperties();
        LOG.info("ElasticSearch instance running at {}", (Object)this.getHttpHostAddress());
    }

    public void shutdown() {
        LOG.info("Stopping the ElasticSearch container");
        this.container.stop();
    }

    public ElasticsearchContainer getContainer() {
        return this.container;
    }
}

