/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.dispatch.router.services;

import org.apache.camel.test.infra.messaging.services.MessagingContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class DispatchRouterContainer
extends GenericContainer<DispatchRouterContainer>
implements MessagingContainer {
    private static final int DEFAULT_AMQP_PORT = 5672;
    private static final String IMAGE_NAME = "quay.io/interconnectedcloud/qdrouterd:latest";

    public DispatchRouterContainer() {
        super(IMAGE_NAME);
        ((DispatchRouterContainer)this.withExposedPorts(new Integer[]{5672})).waitingFor((WaitStrategy)Wait.forListeningPort());
    }

    public DispatchRouterContainer(String imageName, int amqpPort) {
        super(imageName);
        ((DispatchRouterContainer)this.withExposedPorts(new Integer[]{amqpPort})).waitingFor((WaitStrategy)Wait.forListeningPort());
    }

    public DispatchRouterContainer(String imageName) {
        this(imageName, 5672);
    }

    public int getAMQPPort() {
        return this.getMappedPort(5672);
    }

    public String getAMQPEndpoint() {
        return String.format("amqp://%s:%d", this.getHost(), this.getAMQPPort());
    }

    public String defaultEndpoint() {
        return this.getAMQPEndpoint();
    }
}

