/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.couchbase.services;

import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.couchbase.services.CouchbaseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.couchbase.CouchbaseContainer;
import org.testcontainers.utility.DockerImageName;

public class CouchbaseLocalContainerService
implements CouchbaseService,
ContainerService<CouchbaseContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseLocalContainerService.class);
    private final CouchbaseContainer container;

    public CouchbaseLocalContainerService() {
        this(LocalPropertyResolver.getProperty(CouchbaseLocalContainerService.class, (String)"couchbase.container"));
    }

    public CouchbaseLocalContainerService(String imageName) {
        this.container = this.initContainer(imageName);
    }

    public CouchbaseLocalContainerService(CouchbaseContainer container) {
        this.container = container;
    }

    protected CouchbaseContainer initContainer(String imageName) {
        return new CustomCouchbaseContainer(imageName);
    }

    @Override
    public String getConnectionString() {
        return this.container.getConnectionString();
    }

    @Override
    public String getUsername() {
        return this.container.getUsername();
    }

    @Override
    public String getPassword() {
        return this.container.getPassword();
    }

    @Override
    public String getHostname() {
        return this.container.getHost();
    }

    @Override
    public int getPort() {
        return this.container.getBootstrapHttpDirectPort();
    }

    public void registerProperties() {
        System.setProperty("couchbase.hostname", this.getHostname());
        System.setProperty("couchbase.port", String.valueOf(this.getPort()));
        System.setProperty("couchbase.username", this.getUsername());
        System.setProperty("couchbase.password", this.getPassword());
    }

    public void initialize() {
        this.container.start();
        this.registerProperties();
        LOG.debug("Couchbase container running at {}", (Object)this.getConnectionString());
    }

    public void shutdown() {
        this.container.stop();
    }

    public CouchbaseContainer getContainer() {
        return this.container;
    }

    private class CustomCouchbaseContainer
    extends CouchbaseContainer {
        public CustomCouchbaseContainer(String imageName) {
            super(DockerImageName.parse((String)imageName).asCompatibleSubstituteFor("couchbase/server"));
            int kvPort = 11210;
            this.addFixedExposedPort(11210, 11210);
            int managementPort = 8091;
            this.addFixedExposedPort(8091, 8091);
            int viewPort = 8092;
            this.addFixedExposedPort(8092, 8092);
            int queryPort = 8093;
            this.addFixedExposedPort(8093, 8093);
            int searchPort = 8094;
            this.addFixedExposedPort(8094, 8094);
        }
    }
}

