/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.azure.storage.queue.clients;

import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.queue.QueueServiceClient;
import com.azure.storage.queue.QueueServiceClientBuilder;
import com.azure.storage.queue.QueueServiceVersion;

public final class AzureStorageClientUtils {
    private AzureStorageClientUtils() {
    }

    public static QueueServiceClient getClient() {
        String instanceType = System.getProperty("azure.instance.type");
        String accountName = System.getProperty("azure.storage.account.name");
        String accountKey = System.getProperty("azure.storage.account.key");
        StorageSharedKeyCredential credential = new StorageSharedKeyCredential(accountName, accountKey);
        String host = System.getProperty("azure.storage.host");
        String port = System.getProperty("azure.storage.port");
        String endpoint = instanceType == null || instanceType.equals("local-azure-container") ? String.format("http://%s:%s/%s", host, port, accountName) : (host == null || host.isEmpty() ? String.format("https://%s.queue.core.windows.net/%s", accountName, accountKey) : String.format("http://%s:%s/%s", host, port, accountName));
        return new QueueServiceClientBuilder().endpoint(endpoint).credential(credential).httpLogOptions(new HttpLogOptions().setLogLevel(HttpLogDetailLevel.BODY_AND_HEADERS).setPrettyPrintBody(true)).serviceVersion(QueueServiceVersion.V2019_12_12).buildClient();
    }
}

