/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.azure.storage.blob.services;

import org.apache.camel.test.infra.azure.common.services.AzureService;
import org.apache.camel.test.infra.azure.storage.blob.services.AzureStorageBlobLocalContainerService;
import org.apache.camel.test.infra.azure.storage.blob.services.AzureStorageBlobRemoteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AzureStorageBlobServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AzureStorageBlobServiceFactory.class);

    private AzureStorageBlobServiceFactory() {
    }

    public static AzureService createAzureService() {
        String instanceType = System.getProperty("azure.instance.type");
        if (instanceType == null || instanceType.equals("local-azure-container")) {
            return new AzureStorageBlobLocalContainerService();
        }
        if (instanceType.equals("remote")) {
            return new AzureStorageBlobRemoteService();
        }
        LOG.error("Azure instance must be one of 'local-azure-container' or 'remote");
        throw new UnsupportedOperationException(String.format("Invalid Azure instance type: %s", instanceType));
    }
}

