/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.arangodb.services;

import org.apache.camel.test.infra.arangodb.services.ArangoDBLocalContainerService;
import org.apache.camel.test.infra.arangodb.services.ArangoDBRemoteService;
import org.apache.camel.test.infra.arangodb.services.ArangoDBService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArangoDBServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ArangoDBServiceFactory.class);

    private ArangoDBServiceFactory() {
    }

    public static ArangoDBService createService() {
        String instanceType = System.getProperty("arangodb.instance.type");
        if (instanceType == null || instanceType.equals("local-arangodb-container")) {
            return new ArangoDBLocalContainerService();
        }
        if (instanceType.equals("remote")) {
            return new ArangoDBRemoteService();
        }
        LOG.error("ArangoDB instance must be one of 'local-arangodb-container' or 'remote");
        throw new UnsupportedOperationException("Invalid ArangoDB instance type");
    }
}

