/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.arangodb.services;

import org.apache.camel.test.infra.arangodb.services.ArangoDBService;
import org.apache.camel.test.infra.arangodb.services.ArangoDbContainer;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArangoDBLocalContainerService
implements ArangoDBService,
ContainerService<ArangoDbContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(ArangoDBLocalContainerService.class);
    private final ArangoDbContainer container;

    public ArangoDBLocalContainerService() {
        this(System.getProperty("arangodb.container", "arangodb:3.9.1"));
    }

    public ArangoDBLocalContainerService(String imageName) {
        this.container = this.initContainer(imageName);
    }

    public ArangoDBLocalContainerService(ArangoDbContainer container) {
        this.container = container;
    }

    protected ArangoDbContainer initContainer(String imageName) {
        return new ArangoDbContainer(imageName);
    }

    @Override
    public int getPort() {
        return this.container.getServicePort();
    }

    @Override
    public String getHost() {
        return this.container.getHost();
    }

    public void registerProperties() {
        System.setProperty("arangodb.host", this.container.getHost());
        System.setProperty("arangodb.port", String.valueOf(this.container.getServicePort()));
    }

    public void initialize() {
        LOG.info("Trying to start the ArangoDB container");
        this.container.start();
        this.registerProperties();
        LOG.info("ArangoDB instance running at {}", (Object)this.getServiceAddress());
    }

    public void shutdown() {
        LOG.info("Stopping the ArangoDB container");
        this.container.stop();
    }

    public ArangoDbContainer getContainer() {
        return this.container;
    }
}

