/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.arangodb.services;

import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class ArangoDbContainer
extends GenericContainer {
    public static final Integer PORT_DEFAULT = 8529;
    public static final String ARANGO_IMAGE = "arangodb:3.8.1";
    private static final Logger LOGGER = LoggerFactory.getLogger(ArangoDbContainer.class);
    private static final String CONTAINER_NAME = "arango";
    private static final String ARANGO_NO_AUTH = "ARANGO_NO_AUTH";

    public ArangoDbContainer() {
        this(ARANGO_IMAGE);
    }

    public ArangoDbContainer(String containerName) {
        super(containerName);
        this.setWaitStrategy((WaitStrategy)Wait.forListeningPort());
        this.addFixedExposedPort(PORT_DEFAULT, PORT_DEFAULT);
        this.withNetworkAliases(new String[]{CONTAINER_NAME});
        this.withEnv(ARANGO_NO_AUTH, "1");
        this.withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER));
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*is ready for business. Have fun!.*", (int)1));
    }

    public int getServicePort() {
        return this.getMappedPort(PORT_DEFAULT);
    }
}

