/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.BeanManager;

final class FrameworkAnnotatedParameter<X>
implements AnnotatedParameter<X> {
    private final int position;
    private final Type type;
    private final Set<Annotation> annotations;
    private final BeanManager manager;

    FrameworkAnnotatedParameter(Method method, int position, BeanManager manager) {
        this.position = position;
        this.type = method.getGenericParameterTypes()[position];
        this.annotations = new HashSet<Annotation>(Arrays.asList(method.getParameterAnnotations()[position]));
        this.manager = manager;
    }

    public AnnotatedCallable<X> getDeclaringCallable() {
        return null;
    }

    public int getPosition() {
        return this.position;
    }

    public <Y extends Annotation> Y getAnnotation(Class<Y> type) {
        for (Annotation annotation : this.getAnnotations()) {
            if (annotation.annotationType() != type) continue;
            return (Y)((Annotation)type.cast(annotation));
        }
        return null;
    }

    public Set<Annotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    public Type getBaseType() {
        return this.type;
    }

    public Set<Type> getTypeClosure() {
        if (this.type instanceof Class) {
            return this.manager.createAnnotatedType((Class)this.type).getTypeClosure();
        }
        return Collections.singleton(this.type);
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> type) {
        return this.getAnnotation(type) != null;
    }
}

