/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate.tarfile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.file.FileConsumer;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.FileUtil;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarAggregationStrategy
implements AggregationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(TarAggregationStrategy.class);
    private String filePrefix;
    private String fileSuffix = ".tar";
    private boolean preserveFolderStructure;
    private boolean useFilenameHeader;
    private File parentDir = new File(System.getProperty("java.io.tmpdir"));

    public TarAggregationStrategy() {
        this(false, false);
    }

    public TarAggregationStrategy(boolean preserveFolderStructure) {
        this(preserveFolderStructure, false);
    }

    public TarAggregationStrategy(boolean preserveFolderStructure, boolean useFilenameHeader) {
        this.preserveFolderStructure = preserveFolderStructure;
        this.useFilenameHeader = useFilenameHeader;
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public void setFilePrefix(String filePrefix) {
        this.filePrefix = filePrefix;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public void setFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    public File getParentDir() {
        return this.parentDir;
    }

    public void setParentDir(File parentDir) {
        this.parentDir = parentDir;
    }

    public void setParentDir(String parentDir) {
        this.parentDir = new File(parentDir);
    }

    /*
     * Unable to fully structure code
     */
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        answer = oldExchange;
        if (newExchange == null) {
            return oldExchange;
        }
        if (oldExchange == null) {
            try {
                tarFile = FileUtil.createTempFile((String)this.filePrefix, (String)this.fileSuffix, (File)this.parentDir);
                TarAggregationStrategy.LOG.trace("Created temporary file: {}", (Object)tarFile);
            }
            catch (IOException e) {
                throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
            }
            answer = newExchange;
            ((ExtendedExchange)answer.adapt(ExtendedExchange.class)).addOnCompletion((Synchronization)new DeleteTarFileOnCompletion(tarFile));
        } else {
            tarFile = (File)oldExchange.getIn().getBody(File.class);
        }
        body = newExchange.getIn().getBody();
        if (body instanceof WrappedFile) {
            body = ((WrappedFile)body).getFile();
        }
        if (body instanceof File) {
            try {
                appendFile = (File)body;
                if (appendFile.length() <= 0L) ** GOTO lbl35
                entryName = this.preserveFolderStructure != false ? (String)newExchange.getIn().getHeader("CamelFileName", String.class) : newExchange.getIn().getMessageId();
                this.addFileToTar(tarFile, appendFile, this.preserveFolderStructure != false ? entryName : null);
            }
            catch (Exception e) {
                throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
            }
        } else {
            try {
                buffer = (byte[])newExchange.getIn().getMandatoryBody(byte[].class);
                if (buffer.length > 0) {
                    entryName = this.useFilenameHeader != false ? (String)newExchange.getIn().getHeader("CamelFileName", String.class) : newExchange.getIn().getMessageId();
                    this.addEntryToTar(tarFile, entryName, buffer, buffer.length);
                }
            }
            catch (Exception e) {
                throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
            }
        }
lbl35:
        // 3 sources

        genericFile = FileConsumer.asGenericFile((String)tarFile.getParent(), (File)tarFile, (String)Charset.defaultCharset().toString(), (boolean)false);
        genericFile.bindToExchange(answer);
        return answer;
    }

    private void addFileToTar(File source, File file, String fileName) throws IOException, ArchiveException {
        File tmpTar = Files.createTempFile(this.parentDir.toPath(), source.getName(), null, new FileAttribute[0]).toFile();
        tmpTar.delete();
        if (!source.renameTo(tmpTar)) {
            throw new IOException("Could not make temp file (" + source.getName() + ")");
        }
        try (FileInputStream fis = new FileInputStream(tmpTar);
             TarArchiveInputStream tin = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)fis);
             TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)new FileOutputStream(source));){
            tos.setLongFileMode(3);
            tos.setBigNumberMode(2);
            try (FileInputStream in = new FileInputStream(file);){
                this.copyExistingEntries(tin, tos);
                this.addNewEntry(file, fileName, tos, in);
            }
        }
        LOG.trace("Deleting temporary file: {}", (Object)tmpTar);
        FileUtil.deleteFile((File)tmpTar);
    }

    private void addNewEntry(File file, String fileName, TarArchiveOutputStream tos, InputStream in) throws IOException {
        TarArchiveEntry entry = new TarArchiveEntry(fileName == null ? file.getName() : fileName);
        entry.setSize(file.length());
        tos.putArchiveEntry((ArchiveEntry)entry);
        IOUtils.copy((InputStream)in, (OutputStream)tos);
        tos.closeArchiveEntry();
    }

    private void copyExistingEntries(TarArchiveInputStream tin, TarArchiveOutputStream tos) throws IOException {
        ArchiveEntry nextEntry;
        while ((nextEntry = tin.getNextEntry()) != null) {
            tos.putArchiveEntry(nextEntry);
            IOUtils.copy((InputStream)tin, (OutputStream)tos);
            tos.closeArchiveEntry();
        }
    }

    private void addEntryToTar(File source, String entryName, byte[] buffer, int length) throws IOException, ArchiveException {
        File tmpTar = Files.createTempFile(this.parentDir.toPath(), source.getName(), null, new FileAttribute[0]).toFile();
        tmpTar.delete();
        if (!source.renameTo(tmpTar)) {
            throw new IOException("Cannot create temp file: " + source.getName());
        }
        try (FileInputStream fis = new FileInputStream(tmpTar);
             TarArchiveInputStream tin = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)fis);
             TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)new FileOutputStream(source));){
            tos.setLongFileMode(3);
            tos.setBigNumberMode(2);
            this.copyExistingEntries(tin, tos);
            this.createNewEntry(entryName, buffer, length, tos);
        }
        LOG.trace("Deleting temporary file: {}", (Object)tmpTar);
        FileUtil.deleteFile((File)tmpTar);
    }

    private void createNewEntry(String entryName, byte[] buffer, int length, TarArchiveOutputStream tos) throws IOException {
        TarArchiveEntry entry = new TarArchiveEntry(entryName);
        entry.setSize((long)length);
        tos.putArchiveEntry((ArchiveEntry)entry);
        tos.write(buffer, 0, length);
        tos.closeArchiveEntry();
    }

    private static class DeleteTarFileOnCompletion
    implements Synchronization {
        private final File fileToDelete;

        DeleteTarFileOnCompletion(File fileToDelete) {
            this.fileToDelete = fileToDelete;
        }

        public void onFailure(Exchange exchange) {
        }

        public void onComplete(Exchange exchange) {
            LOG.debug("Deleting tar file on completion: {}", (Object)this.fileToDelete);
            FileUtil.deleteFile((File)this.fileToDelete);
        }
    }
}

