/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.tarfile;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import org.apache.camel.Exchange;
import org.apache.camel.converter.stream.OutputStreamBuilder;
import org.apache.camel.dataformat.tarfile.TarIterator;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class TarFileDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private boolean usingIterator;
    private boolean allowEmptyDirectory;
    private boolean preservePathElements;

    public String getDataFormatName() {
        return "tarfile";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        String filepath = (String)exchange.getIn().getHeader("CamelFileName", String.class);
        Long filelength = (Long)exchange.getIn().getHeader("CamelFileLength", Long.class);
        String filename = filepath == null ? (filepath = StringHelper.sanitize((String)exchange.getIn().getMessageId())) : Paths.get(filepath, new String[0]).getFileName().toString();
        TarArchiveOutputStream tos = new TarArchiveOutputStream(stream);
        tos.setLongFileMode(3);
        tos.setBigNumberMode(2);
        InputStream is = (InputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, graph);
        if (filelength == null) {
            filelength = is.available();
        }
        if (this.preservePathElements) {
            this.createTarEntries(tos, filepath, filelength);
        } else {
            this.createTarEntries(tos, filename, filelength);
        }
        try {
            IOHelper.copy((InputStream)is, (OutputStream)tos);
        }
        catch (Throwable throwable) {
            tos.closeArchiveEntry();
            IOHelper.close((Closeable[])new Closeable[]{is, tos});
            throw throwable;
        }
        tos.closeArchiveEntry();
        IOHelper.close((Closeable[])new Closeable[]{is, tos});
        String newFilename = filename + ".tar";
        exchange.getOut().setHeader("CamelFileName", (Object)newFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        Object object;
        if (this.usingIterator) {
            TarIterator tarIterator = new TarIterator(exchange, stream);
            tarIterator.setAllowEmptyDirectory(this.allowEmptyDirectory);
            return tarIterator;
        }
        BufferedInputStream bis = new BufferedInputStream(stream);
        TarArchiveInputStream tis = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)bis);
        OutputStreamBuilder osb = OutputStreamBuilder.withExchange((Exchange)exchange);
        try {
            TarArchiveEntry entry = tis.getNextTarEntry();
            if (entry != null) {
                exchange.getOut().setHeader("CamelFileName", (Object)entry.getName());
                IOHelper.copy((InputStream)tis, (OutputStream)osb);
            }
            if ((entry = tis.getNextTarEntry()) != null) {
                throw new IllegalStateException("Tar file has more than 1 entry.");
            }
            object = osb.build();
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{osb, tis, bis});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{osb, tis, bis});
        return object;
    }

    private void createTarEntries(TarArchiveOutputStream tos, String filepath, Long filelength) throws IOException {
        Iterator<Path> elements = Paths.get(filepath, new String[0]).iterator();
        StringBuilder sb = new StringBuilder();
        while (elements.hasNext()) {
            Path path = elements.next();
            String element = path.toString();
            Long length = filelength;
            if (elements.hasNext()) {
                element = element + "/";
                length = 0L;
            }
            TarArchiveEntry entry = new TarArchiveEntry(sb + element);
            entry.setSize(length.longValue());
            tos.putArchiveEntry((ArchiveEntry)entry);
            sb.append(element);
        }
    }

    public boolean isUsingIterator() {
        return this.usingIterator;
    }

    public void setUsingIterator(boolean usingIterator) {
        this.usingIterator = usingIterator;
    }

    public boolean isAllowEmptyDirectory() {
        return this.allowEmptyDirectory;
    }

    public void setAllowEmptyDirectory(boolean allowEmptyDirectory) {
        this.allowEmptyDirectory = allowEmptyDirectory;
    }

    public boolean isPreservePathElements() {
        return this.preservePathElements;
    }

    public void setPreservePathElements(boolean preservePathElements) {
        this.preservePathElements = preservePathElements;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

