/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.tarfile;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StreamCache;
import org.apache.camel.dataformat.tarfile.TarElementInputStreamWrapper;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.util.IOHelper;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarIterator
implements Iterator<Message>,
Closeable {
    public static final String TARFILE_ENTRY_NAME_HEADER = "CamelTarFileEntryName";
    private static final Logger LOGGER = LoggerFactory.getLogger(TarIterator.class);
    private final Message inputMessage;
    private TarArchiveInputStream tarInputStream;
    private Message nextMessage;
    private Exchange exchange;

    public TarIterator(Exchange exchange, InputStream inputStream) {
        this.exchange = exchange;
        this.inputMessage = exchange.getIn();
        if (inputStream instanceof TarArchiveInputStream) {
            this.tarInputStream = (TarArchiveInputStream)inputStream;
        } else {
            try {
                ArchiveInputStream input = new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)new BufferedInputStream(inputStream));
                this.tarInputStream = (TarArchiveInputStream)input;
            }
            catch (ArchiveException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        this.nextMessage = null;
    }

    @Override
    public boolean hasNext() {
        this.tryAdvanceToNext();
        return this.nextMessage != null;
    }

    @Override
    public Message next() {
        this.tryAdvanceToNext();
        Message next = this.nextMessage;
        this.nextMessage = null;
        return next;
    }

    private void tryAdvanceToNext() {
        if (this.nextMessage != null) {
            return;
        }
        this.nextMessage = this.createNextMessage();
        this.checkNullAnswer(this.nextMessage);
    }

    private Message createNextMessage() {
        if (this.tarInputStream == null) {
            return null;
        }
        try {
            TarArchiveEntry current = this.getNextEntry();
            if (current != null) {
                LOGGER.debug("Reading tarEntry {}", (Object)current.getName());
                DefaultMessage answer = new DefaultMessage();
                answer.getHeaders().putAll(this.inputMessage.getHeaders());
                answer.setHeader(TARFILE_ENTRY_NAME_HEADER, (Object)current.getName());
                answer.setHeader("CamelFileName", (Object)current.getName());
                if (current.getSize() > 0L) {
                    answer.setBody(this.exchange.getContext().getTypeConverter().mandatoryConvertTo(StreamCache.class, this.exchange, (Object)new TarElementInputStreamWrapper((InputStream)this.tarInputStream)));
                } else {
                    answer.setBody((Object)new ByteArrayInputStream(new byte[0]));
                }
                return answer;
            }
            LOGGER.trace("Closed tarInputStream");
            return null;
        }
        catch (Exception exception) {
            this.close();
            throw new RuntimeCamelException((Throwable)exception);
        }
    }

    public void checkNullAnswer(Message answer) {
        if (answer == null) {
            this.close();
        }
    }

    private TarArchiveEntry getNextEntry() throws IOException {
        TarArchiveEntry entry;
        while ((entry = this.tarInputStream.getNextTarEntry()) != null) {
            if (entry.isDirectory()) continue;
            return entry;
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        IOHelper.close((Closeable)this.tarInputStream);
        this.tarInputStream = null;
    }
}

