/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.tarfile;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.dataformat.tarfile.TarElementInputStreamWrapper;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.util.IOHelper;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarIterator
implements Iterator<Message>,
Closeable {
    public static final String TARFILE_ENTRY_NAME_HEADER = "CamelTarFileEntryName";
    private static final Logger LOGGER = LoggerFactory.getLogger(TarIterator.class);
    private final Message inputMessage;
    private TarArchiveInputStream tarInputStream;
    private Message parent;

    public TarIterator(Message inputMessage, InputStream inputStream) {
        this.inputMessage = inputMessage;
        if (inputStream instanceof TarArchiveInputStream) {
            this.tarInputStream = (TarArchiveInputStream)inputStream;
        } else {
            try {
                ArchiveInputStream input = new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)new BufferedInputStream(inputStream));
                this.tarInputStream = (TarArchiveInputStream)input;
            }
            catch (ArchiveException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        this.parent = null;
    }

    @Override
    public boolean hasNext() {
        try {
            boolean availableDataInCurrentEntry;
            if (this.tarInputStream == null) {
                return false;
            }
            boolean bl = availableDataInCurrentEntry = this.tarInputStream.available() > 0;
            if (!availableDataInCurrentEntry) {
                this.parent = this.getNextElement();
                if (this.parent == null) {
                    this.tarInputStream.close();
                    availableDataInCurrentEntry = false;
                } else {
                    availableDataInCurrentEntry = true;
                }
            }
            return availableDataInCurrentEntry;
        }
        catch (IOException exception) {
            throw new RuntimeCamelException((Throwable)exception);
        }
    }

    @Override
    public Message next() {
        if (this.parent == null) {
            this.parent = this.getNextElement();
        }
        Message answer = this.parent;
        this.parent = null;
        this.checkNullAnswer(answer);
        return answer;
    }

    private Message getNextElement() {
        DefaultMessage answer = null;
        if (this.tarInputStream == null) {
            return answer;
        }
        try {
            TarArchiveEntry current = this.getNextEntry();
            if (current != null) {
                LOGGER.debug("Reading tarEntry {}", (Object)current.getName());
                answer = new DefaultMessage();
                answer.getHeaders().putAll(this.inputMessage.getHeaders());
                answer.setHeader(TARFILE_ENTRY_NAME_HEADER, (Object)current.getName());
                answer.setHeader("CamelFileName", (Object)current.getName());
                if (current.getSize() > 0L) {
                    answer.setBody((Object)new TarElementInputStreamWrapper((InputStream)this.tarInputStream));
                } else {
                    answer.setBody((Object)new ByteArrayInputStream(new byte[0]));
                }
                return answer;
            }
            LOGGER.trace("Closed tarInputStream");
        }
        catch (IOException exception) {
            throw new RuntimeCamelException((Throwable)exception);
        }
        return answer;
    }

    public void checkNullAnswer(Message answer) {
        if (answer == null && this.tarInputStream != null) {
            IOHelper.close((Closeable)this.tarInputStream);
            this.tarInputStream = null;
        }
    }

    private TarArchiveEntry getNextEntry() throws IOException {
        TarArchiveEntry entry;
        while ((entry = this.tarInputStream.getNextTarEntry()) != null) {
            if (entry.isDirectory()) continue;
            return entry;
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        if (this.tarInputStream != null) {
            this.tarInputStream.close();
            this.tarInputStream = null;
        }
    }
}

