/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.tahu.handlers;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.tahu.handlers.TahuEdgeClient;
import org.apache.camel.component.tahu.handlers.TahuEdgeMetricHandler;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.tahu.SparkplugParsingException;
import org.eclipse.tahu.message.SparkplugBPayloadDecoder;
import org.eclipse.tahu.message.model.DeviceDescriptor;
import org.eclipse.tahu.message.model.EdgeNodeDescriptor;
import org.eclipse.tahu.message.model.MessageType;
import org.eclipse.tahu.message.model.Metric;
import org.eclipse.tahu.message.model.SparkplugBPayload;
import org.eclipse.tahu.message.model.SparkplugDescriptor;
import org.eclipse.tahu.message.model.StatePayload;
import org.eclipse.tahu.message.model.Topic;
import org.eclipse.tahu.mqtt.ClientCallback;
import org.eclipse.tahu.mqtt.MqttClientId;
import org.eclipse.tahu.mqtt.MqttServerName;
import org.eclipse.tahu.mqtt.MqttServerUrl;
import org.eclipse.tahu.util.SparkplugUtil;
import org.eclipse.tahu.util.TopicUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

class TahuEdgeClientCallback
implements ClientCallback {
    private static final Logger LOG = LoggerFactory.getLogger(TahuEdgeClientCallback.class);
    private TahuEdgeClient client;
    private final EdgeNodeDescriptor edgeNodeDescriptor;
    private final TahuEdgeMetricHandler tahuEdgeNodeMetricHandler;
    private final Marker loggingMarker;

    TahuEdgeClientCallback(EdgeNodeDescriptor edgeNodeDescriptor, TahuEdgeMetricHandler tahuEdgeNodeMetricHandler) {
        this.edgeNodeDescriptor = edgeNodeDescriptor;
        this.tahuEdgeNodeMetricHandler = tahuEdgeNodeMetricHandler;
        this.loggingMarker = MarkerFactory.getMarker((String)edgeNodeDescriptor.getDescriptorString());
    }

    void setClient(TahuEdgeClient client) {
        this.client = client;
    }

    public void messageArrived(MqttServerName mqttServerName, MqttServerUrl mqttServerUrl, MqttClientId mqttClientId, String rawTopic, MqttMessage mqttMessage) {
        Topic topic;
        try {
            topic = TopicUtil.parseTopic((String)rawTopic);
        }
        catch (SparkplugParsingException e) {
            throw new RuntimeCamelException("Exception caught parsing Sparkplug topic " + rawTopic, (Throwable)e);
        }
        if (!"spBv1.0".equals(topic.getNamespace())) {
            LOG.warn(this.loggingMarker, "Received message on non-Sparkplug topic: {}", (Object)topic);
        } else if (topic.isType(MessageType.STATE)) {
            this.handleSTATEMessage(topic, mqttMessage);
        } else if (topic.isType(MessageType.NDEATH) && topic.getEdgeNodeDescriptor().equals((Object)this.edgeNodeDescriptor)) {
            this.handleNDEATHMessage(topic, mqttMessage);
        } else if (topic.isType(MessageType.NCMD) || topic.isType(MessageType.DCMD)) {
            this.handleCMDMessage(topic, mqttMessage);
        } else {
            LOG.debug(this.loggingMarker, "Received unexpected Sparkplug message of type {} - ignoring", (Object)topic.getType());
        }
    }

    void handleSTATEMessage(Topic topic, MqttMessage mqttMessage) {
        LOG.debug(this.loggingMarker, "Received STATE message: {} :: {}", (Object)topic, (Object)new String(mqttMessage.getPayload()));
        try {
            ObjectMapper mapper = new ObjectMapper();
            StatePayload statePayload = (StatePayload)mapper.readValue(mqttMessage.getPayload(), StatePayload.class);
            this.client.handleStateMessage(topic.getHostApplicationId(), statePayload);
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Exception caught handling STATE message with topic " + String.valueOf(topic) + " and payload " + new String(mqttMessage.getPayload()), (Throwable)e);
        }
    }

    void handleNDEATHMessage(Topic topic, MqttMessage mqttMessage) {
        if (!this.client.isDisconnectedOrDisconnecting()) {
            if (this.client.isConnectedToPrimaryHost()) {
                long messageBdSeq;
                try {
                    SparkplugBPayload payload = new SparkplugBPayloadDecoder().buildFromByteArray(mqttMessage.getPayload(), null);
                    messageBdSeq = SparkplugUtil.getBdSequenceNumber((SparkplugBPayload)payload);
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Exception caught handling DEATH message while connected to primary host on topic " + String.valueOf(topic), (Throwable)e);
                }
                long currentBirthBdSeq = this.tahuEdgeNodeMetricHandler.getCurrentBirthBdSeq();
                if (currentBirthBdSeq == messageBdSeq) {
                    this.handleRebirthRequest();
                } else {
                    LOG.warn(this.loggingMarker, "Received unexpected LWT for {} with different bdSeq - expected {} received {} - ignoring", new Object[]{this.edgeNodeDescriptor, currentBirthBdSeq, messageBdSeq});
                }
            } else {
                LOG.debug(this.loggingMarker, "Received unexpected LWT for {} but not connected to primary host - ignoring", (Object)this.edgeNodeDescriptor);
            }
        } else {
            LOG.debug(this.loggingMarker, "Received expected LWT for {} - no action required", (Object)topic.getEdgeNodeDescriptor());
        }
    }

    void handleRebirthRequest() {
        LOG.warn(this.loggingMarker, "Received unexpected LWT for {} - publishing BIRTH sequence", (Object)this.edgeNodeDescriptor);
        try {
            this.client.handleRebirthRequest(true);
        }
        catch (Exception e) {
            LOG.warn(this.loggingMarker, "Received unexpected LWT but failed to publish new BIRTH sequence for {} - continuing", (Object)this.edgeNodeDescriptor, (Object)e);
        }
    }

    void handleCMDMessage(Topic topic, MqttMessage mqttMessage) {
        try {
            SparkplugBPayloadDecoder decoder = new SparkplugBPayloadDecoder();
            SparkplugBPayload payload = (SparkplugBPayload)decoder.buildFromByteArray(mqttMessage.getPayload(), null);
            if (topic.isType(MessageType.NCMD)) {
                this.handleNCMDMessage(payload);
            } else if (topic.isType(MessageType.DCMD)) {
                this.handleDCMDMessage(payload, topic.getDeviceId());
            }
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Exception caught decoding Sparkplug message with topic " + String.valueOf(topic) + " and payload " + new String(mqttMessage.getPayload()), (Throwable)e);
        }
    }

    void handleNCMDMessage(SparkplugBPayload ncmdPayload) {
        List<Metric> responseMetrics = this.tahuEdgeNodeMetricHandler.processCMDMetrics(ncmdPayload, (SparkplugDescriptor)this.edgeNodeDescriptor);
        if (!responseMetrics.isEmpty()) {
            SparkplugBPayload ndataPayload = new SparkplugBPayload.SparkplugBPayloadBuilder().addMetrics(responseMetrics).createPayload();
            LOG.debug(this.loggingMarker, "Publishing NDATA based on NCMD message for {}", (Object)this.edgeNodeDescriptor);
            this.client.publishNodeData(ndataPayload);
        } else {
            LOG.warn(this.loggingMarker, "Received NCMD with no valid metrics to write for {} - ignoring", (Object)this.edgeNodeDescriptor);
        }
    }

    void handleDCMDMessage(SparkplugBPayload dcmdPayload, String deviceId) {
        DeviceDescriptor deviceDescriptor = new DeviceDescriptor(this.edgeNodeDescriptor, deviceId);
        List<Metric> responseMetrics = this.tahuEdgeNodeMetricHandler.processCMDMetrics(dcmdPayload, (SparkplugDescriptor)deviceDescriptor);
        if (!responseMetrics.isEmpty()) {
            SparkplugBPayload ddataPayload = new SparkplugBPayload.SparkplugBPayloadBuilder().addMetrics(responseMetrics).createPayload();
            LOG.debug(this.loggingMarker, "Publishing DDATA based on DCMD message for {}", (Object)deviceDescriptor);
            this.client.publishDeviceData(deviceId, ddataPayload);
        } else {
            LOG.warn(this.loggingMarker, "Received DCMD with no valid metrics to write for {} - ignoring", (Object)deviceDescriptor);
        }
    }

    public void shutdown() {
    }

    public void connectionLost(MqttServerName mqttServerName, MqttServerUrl mqttServerUrl, MqttClientId mqttClientId, Throwable throwable) {
    }

    public void connectComplete(boolean reconnect, MqttServerName mqttServerName, MqttServerUrl mqttServerUrl, MqttClientId mqttClientId) {
    }
}

