/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.generator.swagger;

import io.swagger.models.Path;
import org.apache.camel.generator.swagger.CodeEmitter;
import org.apache.camel.generator.swagger.DestinationGenerator;
import org.apache.camel.generator.swagger.OperationFilter;
import org.apache.camel.generator.swagger.OperationVisitor;
import org.apache.camel.util.ObjectHelper;

class PathVisitor<T> {
    private final DestinationGenerator destinationGenerator;
    private final CodeEmitter<T> emitter;
    private final OperationFilter filter;

    PathVisitor(String basePath, CodeEmitter<T> emitter, OperationFilter filter, DestinationGenerator destinationGenerator) {
        this.emitter = emitter;
        this.filter = filter;
        this.destinationGenerator = destinationGenerator;
        if (ObjectHelper.isEmpty((Object)basePath)) {
            emitter.emit("rest", new Object[0]);
        } else {
            emitter.emit("rest", basePath);
        }
    }

    void visit(String path, Path definition) {
        OperationVisitor<T> restDslOperation = new OperationVisitor<T>(this.emitter, this.filter, path, this.destinationGenerator);
        definition.getOperationMap().forEach(restDslOperation::visit);
    }
}

