/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.generator.swagger;

import io.swagger.models.Swagger;
import org.apache.camel.CamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.generator.swagger.PathVisitor;
import org.apache.camel.generator.swagger.RestDefinitionEmitter;
import org.apache.camel.generator.swagger.RestDslGenerator;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.util.ObjectHelper;

public class RestDslXmlGenerator
extends RestDslGenerator<RestDslXmlGenerator> {
    private boolean blueprint;

    RestDslXmlGenerator(Swagger swagger) {
        super(swagger);
    }

    public RestDslXmlGenerator withBlueprint() {
        this.blueprint = true;
        return this;
    }

    public String generate(CamelContext context) throws Exception {
        RestDefinitionEmitter emitter = new RestDefinitionEmitter(context);
        PathVisitor<RestsDefinition> restDslStatement = new PathVisitor<RestsDefinition>(this.swagger.getBasePath(), emitter, this.filter, this.destinationGenerator());
        this.swagger.getPaths().forEach(restDslStatement::visit);
        RestsDefinition rests = emitter.result();
        String xml = ModelHelper.dumpModelAsXml((CamelContext)context, (NamedNode)rests);
        if (this.blueprint) {
            xml = xml.replace("http://camel.apache.org/schema/spring", "http://camel.apache.org/schema/blueprint");
        }
        xml = xml.replaceAll(" customId=\"true\"", "");
        xml = xml.replaceAll(" customId=\"false\"", "");
        if (this.restComponent != null) {
            String extra = "<restConfiguration component=\"" + this.restComponent + "\"";
            if (this.restContextPath != null) {
                extra = extra.concat(" contextPath=\"" + this.restContextPath + "\"");
            }
            if (ObjectHelper.isNotEmpty((Object)this.apiContextPath)) {
                extra = extra.concat(" apiContextPath=\"" + this.apiContextPath + "\"");
            }
            extra = extra.concat("/>");
            xml = xml.replaceFirst("<rest>", extra + "\n    <rest>");
            xml = xml.replaceFirst("<rest ", extra + "\n    <rest ");
        }
        return xml;
    }
}

