/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.swagger;

import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.parameters.SerializableParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestOperationParamDefinition;
import org.apache.camel.model.rest.RestOperationResponseMsgDefinition;
import org.apache.camel.model.rest.RestParamType;
import org.apache.camel.model.rest.VerbDefinition;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.swagger.RestModelConverters;
import org.apache.camel.swagger.SwaggerHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;

public class RestSwaggerReader {
    public Swagger read(List<RestDefinition> rests, String route, BeanConfig config, String camelContextId, ClassResolver classResolver) {
        Swagger swagger = new Swagger();
        for (RestDefinition rest : rests) {
            if (ObjectHelper.isNotEmpty((Object)route) && !route.equals("/") && !rest.getPath().equals(route)) continue;
            this.parse(swagger, rest, camelContextId, classResolver);
        }
        swagger = config.configure(swagger);
        return swagger;
    }

    private void parse(Swagger swagger, RestDefinition rest, String camelContextId, ClassResolver classResolver) {
        ArrayList verbs = new ArrayList(rest.getVerbs());
        Collections.sort(verbs, new VerbOrdering());
        String pathAsTag = rest.getTag() != null ? rest.getTag() : FileUtil.stripLeadingSeparator((String)rest.getPath());
        String summary = rest.getDescriptionText();
        if (ObjectHelper.isNotEmpty((Object)pathAsTag)) {
            Tag tag = new Tag();
            tag.description(summary);
            tag.name(pathAsTag);
            swagger.addTag(tag);
        }
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        for (VerbDefinition verb : verbs) {
            String type = verb.getType();
            if (ObjectHelper.isNotEmpty((Object)type)) {
                if (type.endsWith("[]")) {
                    type = type.substring(0, type.length() - 2);
                }
                types.add(type);
            }
            if (ObjectHelper.isNotEmpty((Object)(type = verb.getOutType()))) {
                if (type.endsWith("[]")) {
                    type = type.substring(0, type.length() - 2);
                }
                types.add(type);
            }
            if (verb.getResponseMsgs() == null) continue;
            for (RestOperationResponseMsgDefinition def : verb.getResponseMsgs()) {
                type = def.getResponseModel();
                if (!ObjectHelper.isNotEmpty((Object)type)) continue;
                if (type.endsWith("[]")) {
                    type = type.substring(0, type.length() - 2);
                }
                types.add(type);
            }
        }
        for (String type : types) {
            Class clazz = classResolver.resolveClass(type);
            this.appendModels(clazz, swagger);
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        String basePath = rest.getPath();
        for (VerbDefinition verb : verbs) {
            String produces;
            String consumes;
            String method = verb.asVerb().toLowerCase(Locale.US);
            String opPath = SwaggerHelper.buildUrl(basePath, verb.getUri());
            Operation op = new Operation();
            if (ObjectHelper.isNotEmpty((Object)pathAsTag)) {
                op.addTag(pathAsTag);
            }
            op.getVendorExtensions().put("x-camelContextId", camelContextId);
            op.getVendorExtensions().put("x-routeId", verb.getRouteId());
            Path path = swagger.getPath(opPath);
            if (path == null) {
                path = new Path();
                paths.add(path);
            }
            path = path.set(method, op);
            String string = consumes = verb.getConsumes() != null ? verb.getConsumes() : rest.getConsumes();
            if (consumes != null) {
                String[] parts;
                for (String part : parts = consumes.split(",")) {
                    op.addConsumes(part);
                }
            }
            String string2 = produces = verb.getProduces() != null ? verb.getProduces() : rest.getProduces();
            if (produces != null) {
                String[] parts;
                for (String part : parts = produces.split(",")) {
                    op.addProduces(part);
                }
            }
            if (verb.getDescriptionText() != null) {
                op.summary(verb.getDescriptionText());
            }
            for (RestOperationParamDefinition param : verb.getParams()) {
                BodyParameter parameter = null;
                if (param.getType().equals((Object)RestParamType.body)) {
                    parameter = new BodyParameter();
                } else if (param.getType().equals((Object)RestParamType.form)) {
                    parameter = new FormParameter();
                } else if (param.getType().equals((Object)RestParamType.header)) {
                    parameter = new HeaderParameter();
                } else if (param.getType().equals((Object)RestParamType.path)) {
                    parameter = new PathParameter();
                } else if (param.getType().equals((Object)RestParamType.query)) {
                    parameter = new QueryParameter();
                }
                if (parameter == null) continue;
                parameter.setName(param.getName());
                parameter.setAccess(param.getAccess());
                parameter.setDescription(param.getDescription());
                parameter.setRequired(param.getRequired().booleanValue());
                if (parameter instanceof SerializableParameter) {
                    SerializableParameter sp = (SerializableParameter)parameter;
                    if (param.getDataType() != null) {
                        sp.setType(param.getDataType());
                    }
                    if (param.getAllowableValues() != null) {
                        sp.setEnum(param.getAllowableValues());
                    }
                }
                if (parameter instanceof BodyParameter) {
                    String ref;
                    BodyParameter bp = parameter;
                    if (verb.getType() != null && (ref = this.modelTypeAsRef(verb.getType(), swagger)) != null) {
                        bp.setSchema((Model)new RefModel(ref));
                    }
                }
                op.addParameter((Parameter)parameter);
            }
            if (verb.getOutType() != null) {
                Response response = new Response();
                Property prop = this.modelTypeAsProperty(verb.getOutType(), swagger);
                response.setSchema(prop);
                response.setDescription("Output type");
                op.addResponse("200", response);
            }
            for (RestOperationResponseMsgDefinition msg : verb.getResponseMsgs()) {
                Response response = null;
                if (op.getResponses() != null) {
                    response = (Response)op.getResponses().get(msg.getCode());
                }
                if (response == null) {
                    response = new Response();
                }
                if (ObjectHelper.isNotEmpty((Object)msg.getResponseModel())) {
                    Property prop = this.modelTypeAsProperty(msg.getResponseModel(), swagger);
                    response.setSchema(prop);
                }
                response.setDescription(msg.getMessage());
                op.addResponse(msg.getCode(), response);
            }
            swagger.path(opPath, path);
        }
    }

    private Model asModel(String typeName, Swagger swagger) {
        boolean array = typeName.endsWith("[]");
        if (array) {
            typeName = typeName.substring(0, typeName.length() - 2);
        }
        if (swagger.getDefinitions() != null) {
            for (Model model : swagger.getDefinitions().values()) {
                StringProperty modelType = (StringProperty)model.getVendorExtensions().get("x-className");
                if (modelType == null || !typeName.equals(modelType.getFormat())) continue;
                return model;
            }
        }
        return null;
    }

    private String modelTypeAsRef(String typeName, Swagger swagger) {
        Model model;
        boolean array = typeName.endsWith("[]");
        if (array) {
            typeName = typeName.substring(0, typeName.length() - 2);
        }
        if ((model = this.asModel(typeName, swagger)) != null) {
            typeName = ((ModelImpl)model).getName();
            return typeName;
        }
        return null;
    }

    private Property modelTypeAsProperty(String typeName, Swagger swagger) {
        String ref;
        RefProperty prop;
        boolean array = typeName.endsWith("[]");
        if (array) {
            typeName = typeName.substring(0, typeName.length() - 2);
        }
        Object object = prop = (ref = this.modelTypeAsRef(typeName, swagger)) != null ? new RefProperty(ref) : new StringProperty(typeName);
        if (array) {
            return new ArrayProperty((Property)prop);
        }
        return prop;
    }

    private void appendModels(Class clazz, Swagger swagger) {
        RestModelConverters converters = new RestModelConverters();
        Map<String, Model> models = converters.readClass(clazz);
        for (Map.Entry<String, Model> entry : models.entrySet()) {
            swagger.model(entry.getKey(), entry.getValue());
        }
    }

    private static class VerbOrdering
    implements Comparator<VerbDefinition> {
        private VerbOrdering() {
        }

        @Override
        public int compare(VerbDefinition a, VerbDefinition b) {
            int num;
            String u1 = "";
            if (a.getUri() != null) {
                u1 = a.getUri().replace("{", "_");
            }
            String u2 = "";
            if (b.getUri() != null) {
                u2 = b.getUri().replace("{", "_");
            }
            if ((num = u1.compareTo(u2)) == 0) {
                num = a.asVerb().compareTo(b.asVerb());
            }
            return num;
        }
    }
}

