/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.spi.InternalProcessorFactory;
import org.apache.camel.support.AsyncCallbackToCompletableFutureAdapter;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;

public class DeferProducer
extends ServiceSupport
implements Producer,
AsyncProcessor {
    private Producer delegate;
    private final Endpoint endpoint;

    public DeferProducer(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        if (this.delegate == null) {
            throw new IllegalStateException("Not started");
        }
        this.delegate.process(exchange);
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.delegate == null) {
            exchange.setException((Throwable)new IllegalStateException("Not started"));
            callback.done(true);
            return true;
        }
        Producer producer = this.delegate;
        if (producer instanceof AsyncProcessor) {
            AsyncProcessor asyncProcessor = (AsyncProcessor)producer;
            return asyncProcessor.process(exchange, callback);
        }
        try {
            this.process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    public CompletableFuture<Exchange> processAsync(Exchange exchange) {
        AsyncCallbackToCompletableFutureAdapter<Exchange> callback = new AsyncCallbackToCompletableFutureAdapter<Exchange>(exchange);
        this.process(exchange, callback);
        return callback.getFuture();
    }

    protected void doStart() throws Exception {
        Endpoint lookup = this.endpoint.getCamelContext().getEndpoint(this.endpoint.getEndpointUri());
        InternalProcessorFactory pf = PluginHelper.getInternalProcessorFactory(this.endpoint.getCamelContext());
        this.delegate = pf.createProducer(lookup);
        ServiceHelper.startService((Service)this.delegate);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Service)this.delegate);
    }

    public boolean isSingleton() {
        if (this.delegate != null) {
            return this.delegate.isSingleton();
        }
        return true;
    }

    public Endpoint getEndpoint() {
        if (this.delegate != null) {
            return this.delegate.getEndpoint();
        }
        return this.endpoint;
    }

    public String toString() {
        if (this.delegate != null) {
            return this.delegate.toString();
        }
        return "DelegateProducer[" + String.valueOf(this.endpoint) + "]";
    }
}

