/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.AsyncProducer;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.PollingConsumer;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.HasId;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.BridgeExceptionHandlerToErrorHandler;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.EventDrivenPollingConsumer;
import org.apache.camel.support.IntrospectionSupport;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

public abstract class DefaultEndpoint
extends ServiceSupport
implements Endpoint,
HasId,
CamelContextAware {
    private final String id = EndpointHelper.createEndpointId();
    private transient String endpointUriToString;
    private String endpointUri;
    private CamelContext camelContext;
    private Component component;
    @UriParam(label="consumer", optionalPrefix="consumer.", description="Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.")
    private boolean bridgeErrorHandler;
    @UriParam(label="consumer,advanced", optionalPrefix="consumer.", description="To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.")
    private ExceptionHandler exceptionHandler;
    @UriParam(label="consumer,advanced", description="Sets the exchange pattern when the consumer creates an exchange.")
    private ExchangePattern exchangePattern = ExchangePattern.InOnly;
    @UriParam(defaultValue="false", label="advanced", description="Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).")
    private boolean synchronous;
    private Map<String, Object> consumerProperties;
    private int pollingConsumerQueueSize = 1000;
    private boolean pollingConsumerBlockWhenFull = true;
    private long pollingConsumerBlockTimeout;

    protected DefaultEndpoint(String endpointUri, Component component) {
        this.camelContext = component == null ? null : component.getCamelContext();
        this.component = component;
        this.setEndpointUri(endpointUri);
    }

    protected DefaultEndpoint() {
    }

    public int hashCode() {
        return this.getEndpointUri().hashCode() * 37 + 1;
    }

    public boolean equals(Object object) {
        if (object instanceof DefaultEndpoint) {
            DefaultEndpoint that = (DefaultEndpoint)((Object)object);
            String thisContextName = this.getCamelContext() != null ? this.getCamelContext().getName() : null;
            String thatContextName = that.getCamelContext() != null ? that.getCamelContext().getName() : null;
            return ObjectHelper.equal((Object)this.getEndpointUri(), (Object)that.getEndpointUri()) && ObjectHelper.equal((Object)thisContextName, (Object)thatContextName);
        }
        return false;
    }

    public String toString() {
        if (this.endpointUriToString == null) {
            String value = null;
            try {
                value = this.getEndpointUri();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.endpointUriToString = URISupport.sanitizeUri((String)value);
        }
        return this.endpointUriToString;
    }

    public String getId() {
        return this.id;
    }

    public String getEndpointUri() {
        if (this.endpointUri == null) {
            this.endpointUri = this.createEndpointUri();
            if (this.endpointUri == null) {
                throw new IllegalArgumentException("endpointUri is not specified and " + ((Object)((Object)this)).getClass().getName() + " does not implement createEndpointUri() to create a default value");
            }
        }
        return this.endpointUri;
    }

    public String getEndpointKey() {
        if (this.isLenientProperties()) {
            String uri = this.getEndpointUri();
            if (uri.indexOf(63) != -1) {
                return StringHelper.before((String)uri, (String)"?");
            }
            return uri;
        }
        return this.getEndpointUri();
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public AsyncProducer createAsyncProducer() throws Exception {
        return AsyncProcessorConverterHelper.convert(this.createProducer());
    }

    public Component getComponent() {
        return this.component;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating EventDrivenPollingConsumer with queueSize: {} blockWhenFull: {} blockTimeout: {}", new Object[]{this.getPollingConsumerQueueSize(), this.isPollingConsumerBlockWhenFull(), this.getPollingConsumerBlockTimeout()});
        }
        EventDrivenPollingConsumer consumer = new EventDrivenPollingConsumer((Endpoint)this, this.getPollingConsumerQueueSize());
        consumer.setBlockWhenFull(this.isPollingConsumerBlockWhenFull());
        consumer.setBlockTimeout(this.getPollingConsumerBlockTimeout());
        return consumer;
    }

    public Exchange createExchange() {
        return this.createExchange(this.getExchangePattern());
    }

    public Exchange createExchange(ExchangePattern pattern) {
        return new DefaultExchange(this, pattern);
    }

    public ExchangePattern getExchangePattern() {
        return this.exchangePattern;
    }

    public void setExchangePattern(ExchangePattern exchangePattern) {
        this.exchangePattern = exchangePattern;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public boolean isBridgeErrorHandler() {
        return this.bridgeErrorHandler;
    }

    public void setBridgeErrorHandler(boolean bridgeErrorHandler) {
        this.bridgeErrorHandler = bridgeErrorHandler;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public int getPollingConsumerQueueSize() {
        return this.pollingConsumerQueueSize;
    }

    public void setPollingConsumerQueueSize(int pollingConsumerQueueSize) {
        this.pollingConsumerQueueSize = pollingConsumerQueueSize;
    }

    public boolean isPollingConsumerBlockWhenFull() {
        return this.pollingConsumerBlockWhenFull;
    }

    public void setPollingConsumerBlockWhenFull(boolean pollingConsumerBlockWhenFull) {
        this.pollingConsumerBlockWhenFull = pollingConsumerBlockWhenFull;
    }

    public long getPollingConsumerBlockTimeout() {
        return this.pollingConsumerBlockTimeout;
    }

    public void setPollingConsumerBlockTimeout(long pollingConsumerBlockTimeout) {
        this.pollingConsumerBlockTimeout = pollingConsumerBlockTimeout;
    }

    public void configureProperties(Map<String, Object> options) {
        Map<String, Object> consumerProperties = IntrospectionSupport.extractProperties(options, "consumer.");
        if (consumerProperties != null && !consumerProperties.isEmpty()) {
            this.setConsumerProperties(consumerProperties);
        }
    }

    protected void setProperties(Object bean, Map<String, Object> parameters) throws Exception {
        EndpointHelper.setReferenceProperties(this.getCamelContext(), bean, parameters);
        EndpointHelper.setProperties(this.getCamelContext(), bean, parameters);
    }

    protected String createEndpointUri() {
        return null;
    }

    public void setEndpointUriIfNotSpecified(String value) {
        if (this.endpointUri == null) {
            this.setEndpointUri(value);
        }
    }

    protected void setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
    }

    public boolean isLenientProperties() {
        return false;
    }

    public Map<String, Object> getConsumerProperties() {
        if (this.consumerProperties == null) {
            this.consumerProperties = new HashMap<String, Object>();
        }
        return this.consumerProperties;
    }

    public void setConsumerProperties(Map<String, Object> consumerProperties) {
        if (consumerProperties != null && !consumerProperties.isEmpty()) {
            if (this.consumerProperties == null) {
                this.consumerProperties = new HashMap<String, Object>(consumerProperties);
            } else {
                this.consumerProperties.putAll(consumerProperties);
            }
        }
    }

    protected void configureConsumer(Consumer consumer) throws Exception {
        if (consumer instanceof CamelContextAware) {
            ((CamelContextAware)consumer).setCamelContext(this.getCamelContext());
        }
        if (this.consumerProperties != null) {
            HashMap<String, Object> copy = new HashMap<String, Object>(this.consumerProperties);
            EndpointHelper.setReferenceProperties(this.getCamelContext(), consumer, copy);
            EndpointHelper.setProperties(this.getCamelContext(), consumer, copy);
            Object bridge = copy.remove("bridgeErrorHandler");
            if (bridge != null && "true".equals(bridge)) {
                if (consumer instanceof DefaultConsumer) {
                    DefaultConsumer defaultConsumer = (DefaultConsumer)consumer;
                    defaultConsumer.setExceptionHandler(new BridgeExceptionHandlerToErrorHandler(defaultConsumer));
                } else {
                    throw new IllegalArgumentException("Option consumer.bridgeErrorHandler is only supported by endpoints, having their consumer extend DefaultConsumer. The consumer is a " + consumer.getClass().getName() + " class.");
                }
            }
            if (!this.isLenientProperties() && copy.size() > 0) {
                throw new ResolveEndpointFailedException(this.getEndpointUri(), "There are " + copy.size() + " parameters that couldn't be set on the endpoint consumer. Check the uri if the parameters are spelt correctly and that they are properties of the endpoint. Unknown consumer parameters=[" + copy + "]");
            }
        }
    }

    protected void configurePollingConsumer(PollingConsumer consumer) throws Exception {
        this.configureConsumer((Consumer)consumer);
    }

    protected void doStart() throws Exception {
        if (this.bridgeErrorHandler) {
            this.getConsumerProperties().put("bridgeErrorHandler", "true");
        }
        if (this.exceptionHandler != null) {
            this.getConsumerProperties().put("exceptionHandler", this.exceptionHandler);
        }
    }

    protected void doStop() throws Exception {
    }
}

