/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stitch;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.stitch.StitchConfiguration;
import org.apache.camel.component.stitch.StitchEndpoint;
import org.apache.camel.component.stitch.client.models.StitchResponse;
import org.apache.camel.component.stitch.operations.StitchProducerOperations;
import org.apache.camel.support.DefaultAsyncProducer;

public class StitchProducer
extends DefaultAsyncProducer {
    private StitchProducerOperations operations;

    public StitchProducer(Endpoint endpoint) {
        super(endpoint);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.operations = new StitchProducerOperations(this.getEndpoint().getStitchClient(), this.getConfiguration());
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            return this.operations.sendEvents(exchange.getMessage(), response -> this.setDataOnExchange((StitchResponse)response, exchange), callback);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
    }

    public StitchEndpoint getEndpoint() {
        return (StitchEndpoint)super.getEndpoint();
    }

    public StitchConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    private void setDataOnExchange(StitchResponse response, Exchange exchange) {
        Message message = exchange.getIn();
        message.setBody((Object)response.getMessage());
        message.setHeader("CamelStitchCode", (Object)response.getHttpStatusCode());
        message.setHeader("CamelStitchStatus", (Object)response.getStatus());
        message.setHeader("CamelStitchHeaders", response.getHeaders());
    }
}

