/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stitch.client.models;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.component.stitch.client.models.StitchModel;
import org.apache.camel.util.ObjectHelper;

public final class StitchMessage
implements StitchModel {
    public static final String ACTION = "action";
    public static final String SEQUENCE = "sequence";
    public static final String DATA = "data";
    private static final Action DEFAULT_ACTION = Action.UPSERT;
    private static final long DEFAULT_SEQUENCE = System.currentTimeMillis();
    private final Action action;
    private final long sequence;
    private final Map<String, Object> data;

    private StitchMessage(Action action, long sequence, Map<String, Object> data) {
        this.action = action;
        this.sequence = sequence;
        this.data = data;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder fromMap(Map<String, Object> data) {
        Action action = Action.valueOf(data.getOrDefault(ACTION, DEFAULT_ACTION.name()).toString().toUpperCase());
        long sequence = (Long)ObjectHelper.cast(Long.class, (Object)data.getOrDefault(SEQUENCE, DEFAULT_SEQUENCE));
        Map inputData = (Map)ObjectHelper.cast(Map.class, data.getOrDefault(DATA, Collections.emptyMap()));
        return new Builder().withAction(action).withData(inputData).withSequence(sequence);
    }

    public Action getAction() {
        return this.action;
    }

    public long getSequence() {
        return this.sequence;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    @Override
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> resultAsMap = new LinkedHashMap<String, Object>();
        resultAsMap.put(ACTION, this.action.name().toLowerCase());
        resultAsMap.put(SEQUENCE, this.sequence);
        resultAsMap.put(DATA, this.data);
        return resultAsMap;
    }

    public static final class Builder {
        private Action action;
        private Long sequence;
        private Map<String, Object> data = new LinkedHashMap<String, Object>();

        private Builder() {
        }

        public Builder withAction(Action action) {
            if (ObjectHelper.isNotEmpty((Object)((Object)action))) {
                this.action = action;
            }
            return this;
        }

        public Builder withSequence(long sequence) {
            if (ObjectHelper.isNotEmpty((Object)sequence)) {
                this.sequence = sequence;
            }
            return this;
        }

        public Builder withData(Map<String, Object> data) {
            if (ObjectHelper.isNotEmpty(data)) {
                this.data.putAll(data);
            }
            return this;
        }

        public Builder withData(String key, Object data) {
            if (ObjectHelper.isNotEmpty((String)key)) {
                this.data.put(key, data);
            }
            return this;
        }

        public StitchMessage build() {
            if (ObjectHelper.isEmpty(this.data)) {
                throw new IllegalArgumentException("Data cannot be empty.");
            }
            if (ObjectHelper.isEmpty((Object)((Object)this.action))) {
                this.action = DEFAULT_ACTION;
            }
            if (ObjectHelper.isEmpty((Object)this.sequence)) {
                this.sequence = DEFAULT_SEQUENCE;
            }
            return new StitchMessage(this.action, this.sequence, this.data);
        }
    }

    public static enum Action {
        UPSERT;

    }
}

