/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stitch.client.models;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.component.stitch.client.models.StitchMessage;
import org.apache.camel.component.stitch.client.models.StitchModel;
import org.apache.camel.component.stitch.client.models.StitchSchema;
import org.apache.camel.util.ObjectHelper;

public final class StitchRequestBody
implements StitchModel {
    public static final String TABLE_NAME = "table_name";
    public static final String SCHEMA = "schema";
    public static final String MESSAGES = "messages";
    public static final String KEY_NAMES = "key_names";
    private final String tableName;
    private final StitchSchema schema;
    private final Collection<StitchMessage> messages;
    private final Collection<String> keyNames;

    private StitchRequestBody(String tableName, StitchSchema schema, Collection<StitchMessage> messages, Collection<String> keyNames) {
        this.tableName = tableName;
        this.schema = schema;
        this.messages = messages;
        this.keyNames = keyNames;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder fromStitchRequestBody(StitchRequestBody body) {
        return new Builder().withSchema(body.getSchema()).withTableName(body.getTableName()).withKeyNames(body.getKeyNames()).addMessages(body.getMessages());
    }

    public static Builder fromMap(Map<String, Object> data) {
        String tableName = (String)ObjectHelper.cast(String.class, (Object)data.get(TABLE_NAME));
        StitchSchema schema = StitchSchema.builder().addKeywords((Map)ObjectHelper.cast(Map.class, data.getOrDefault(SCHEMA, Collections.emptyMap()))).build();
        Collection messages = ((Collection)ObjectHelper.cast(Collection.class, data.getOrDefault(MESSAGES, Collections.emptyList()))).stream().filter(ObjectHelper::isNotEmpty).map(message -> StitchMessage.fromMap((Map)ObjectHelper.cast(Map.class, (Object)message)).build()).collect(Collectors.toList());
        Collection keyNames = (Collection)ObjectHelper.cast(Collection.class, (Object)data.get(KEY_NAMES));
        return new Builder().withSchema(schema).withTableName(tableName).withKeyNames(keyNames).withSchema(schema).addMessages(messages);
    }

    public String getTableName() {
        return this.tableName;
    }

    public StitchSchema getSchema() {
        return this.schema;
    }

    public Collection<StitchMessage> getMessages() {
        return this.messages;
    }

    public Collection<String> getKeyNames() {
        return this.keyNames;
    }

    @Override
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> resultAsMap = new LinkedHashMap<String, Object>();
        resultAsMap.put(TABLE_NAME, this.tableName);
        resultAsMap.put(SCHEMA, this.schema.toMap());
        resultAsMap.put(MESSAGES, this.messages.stream().map(StitchMessage::toMap).collect(Collectors.toList()));
        resultAsMap.put(KEY_NAMES, this.keyNames);
        return resultAsMap;
    }

    public static final class Builder {
        private String tableName;
        private StitchSchema schema;
        private Collection<StitchMessage> messages = new LinkedList<StitchMessage>();
        private Collection<String> keyNames = new LinkedHashSet<String>();

        private Builder() {
        }

        public Builder withTableName(String tableName) {
            if (ObjectHelper.isNotEmpty((Object)tableName)) {
                this.tableName = tableName;
            }
            return this;
        }

        public Builder withSchema(StitchSchema schema) {
            if (ObjectHelper.isNotEmpty((Object)schema)) {
                this.schema = schema;
            }
            return this;
        }

        public Builder addMessages(Collection<StitchMessage> messages) {
            if (ObjectHelper.isNotEmpty(messages)) {
                this.messages.addAll(messages);
            }
            return this;
        }

        public Builder addMessage(StitchMessage messages) {
            if (ObjectHelper.isNotEmpty((Object)messages)) {
                this.messages.add(messages);
            }
            return this;
        }

        public Builder withKeyNames(String ... keyNames) {
            if (ObjectHelper.isNotEmpty((Object)keyNames)) {
                this.keyNames.addAll(Arrays.stream(keyNames).collect(Collectors.toSet()));
            }
            return this;
        }

        public Builder withKeyNames(Collection<String> keyNames) {
            if (ObjectHelper.isNotEmpty(keyNames)) {
                this.keyNames.addAll(keyNames);
            }
            return this;
        }

        public StitchRequestBody build() {
            if (ObjectHelper.isEmpty((Object)this.tableName) || ObjectHelper.isEmpty((Object)this.schema) || ObjectHelper.isEmpty(this.messages)) {
                throw new IllegalArgumentException("One of the required arguments 'tableName', 'schema' or 'messages' is not set.");
            }
            return new StitchRequestBody(this.tableName, this.schema, this.messages, this.keyNames);
        }
    }
}

