/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class SqlEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":query";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "sql".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "query", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(49);
        props.add("allowNamedParameters");
        props.add("alwaysPopulateStatement");
        props.add("backoffErrorThreshold");
        props.add("backoffIdleThreshold");
        props.add("backoffMultiplier");
        props.add("batch");
        props.add("batchAutoCommitDisabled");
        props.add("breakBatchOnConsumeFail");
        props.add("bridgeErrorHandler");
        props.add("dataSource");
        props.add("delay");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("expectedUpdateCount");
        props.add("fetchSize");
        props.add("greedy");
        props.add("initialDelay");
        props.add("lazyStartProducer");
        props.add("maxMessagesPerPoll");
        props.add("noop");
        props.add("onConsume");
        props.add("onConsumeBatchComplete");
        props.add("onConsumeFailed");
        props.add("outputClass");
        props.add("outputHeader");
        props.add("outputType");
        props.add("parametersCount");
        props.add("placeholder");
        props.add("pollStrategy");
        props.add("prepareStatementStrategy");
        props.add("processingStrategy");
        props.add("query");
        props.add("repeatCount");
        props.add("routeEmptyResultSet");
        props.add("rowMapperFactory");
        props.add("runLoggingLevel");
        props.add("scheduledExecutorService");
        props.add("scheduler");
        props.add("schedulerProperties");
        props.add("sendEmptyMessageWhenIdle");
        props.add("separator");
        props.add("startScheduler");
        props.add("templateOptions");
        props.add("timeUnit");
        props.add("transacted");
        props.add("useFixedDelay");
        props.add("useIterator");
        props.add("useMessageBodyForSql");
        props.add("usePlaceholder");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
        HashSet<String> prefixes = new HashSet<String>(2);
        prefixes.add("scheduler.");
        prefixes.add("template.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableSet(prefixes);
    }
}

