/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import org.apache.camel.CamelContext;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResolverHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiDataFormatResolver
implements DataFormatResolver {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiDataFormatResolver.class);
    private final BundleContext bundleContext;

    public OsgiDataFormatResolver(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public DataFormat resolveDataFormat(String name, CamelContext context) {
        DataFormat dataFormatReg = ResolverHelper.lookupDataFormatInRegistryWithFallback((CamelContext)context, (String)name);
        if (dataFormatReg != null) {
            return dataFormatReg;
        }
        return this.getDataFormat(name, context);
    }

    protected DataFormat getDataFormat(String name, CamelContext context) {
        LOG.trace("Finding DataFormat: {}", (Object)name);
        try {
            ServiceReference[] refs = this.bundleContext.getServiceReferences(DataFormatResolver.class.getName(), "(dataformat=" + name + ")");
            if (refs != null) {
                for (ServiceReference ref : refs) {
                    Object service = this.bundleContext.getService(ref);
                    if (!DataFormatResolver.class.isAssignableFrom(service.getClass())) continue;
                    DataFormatResolver resolver = (DataFormatResolver)service;
                    return resolver.resolveDataFormat(name, context);
                }
            }
            return null;
        }
        catch (InvalidSyntaxException e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

