/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.splunk;

import com.splunk.SSLSecurityProtocol;
import com.splunk.Service;
import org.apache.camel.component.splunk.SplunkConnectionFactory;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;

@UriParams
public class SplunkConfiguration {
    private SplunkConnectionFactory connectionFactory;
    @UriPath(description="Name has no purpose")
    @Metadata(required=true)
    private String name;
    @UriParam(defaultValue="https")
    private String scheme = Service.DEFAULT_SCHEME;
    @UriParam(defaultValue="localhost")
    private String host = Service.DEFAULT_HOST;
    @UriParam(defaultValue="8089")
    private int port = Service.DEFAULT_PORT;
    @UriParam(enums="TLSv1.2,TLSv1.1,TLSv1,SSLv3", defaultValue="TLSv1.2", label="security")
    private SSLSecurityProtocol sslProtocol = SSLSecurityProtocol.TLSv1_2;
    @UriParam(defaultValue="true", label="security")
    private boolean validateCertificates = true;
    @UriParam
    private String app;
    @UriParam
    private String owner;
    @UriParam(label="security", secret=true)
    private String username;
    @UriParam(label="security", secret=true)
    private String password;
    @UriParam(label="security", secret=true)
    private String token;
    @UriParam(defaultValue="5000")
    private int connectionTimeout = 5000;
    @UriParam(label="security")
    private boolean useSunHttpsHandler;
    @UriParam(label="producer")
    private String index;
    @UriParam(label="producer")
    private String sourceType;
    @UriParam(label="producer")
    private String source;
    @UriParam(label="producer")
    private String eventHost;
    @UriParam(label="producer")
    private int tcpReceiverPort;
    @UriParam(label="producer")
    private Integer tcpReceiverLocalPort;
    @UriParam(label="producer", defaultValue="false")
    private boolean raw;
    @UriParam(label="consumer")
    private int count;
    @UriParam(label="consumer")
    private String search;
    @UriParam(label="consumer")
    private String savedSearch;
    @UriParam(label="consumer")
    private String earliestTime;
    @UriParam(label="consumer")
    private String latestTime;
    @UriParam(label="consumer")
    private String initEarliestTime;
    @UriParam(label="consumer")
    private boolean streaming;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getInitEarliestTime() {
        return this.initEarliestTime;
    }

    public void setInitEarliestTime(String initEarliestTime) {
        this.initEarliestTime = initEarliestTime;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String getSearch() {
        return this.search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public String getEarliestTime() {
        return this.earliestTime;
    }

    public void setEarliestTime(String earliestTime) {
        this.earliestTime = earliestTime;
    }

    public String getLatestTime() {
        return this.latestTime;
    }

    public void setLatestTime(String latestTime) {
        this.latestTime = latestTime;
    }

    public int getTcpReceiverPort() {
        return this.tcpReceiverPort;
    }

    public void setTcpReceiverPort(int tcpReceiverPort) {
        this.tcpReceiverPort = tcpReceiverPort;
    }

    public Integer getTcpReceiverLocalPort() {
        return this.tcpReceiverLocalPort;
    }

    public void setTcpReceiverLocalPort(Integer tcpReceiverLocalPort) {
        this.tcpReceiverLocalPort = tcpReceiverLocalPort;
    }

    public boolean isRaw() {
        return this.raw;
    }

    public void setRaw(boolean raw) {
        this.raw = raw;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getEventHost() {
        return this.eventHost;
    }

    public void setEventHost(String eventHost) {
        this.eventHost = eventHost;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getIndex() {
        return this.index;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public SSLSecurityProtocol getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(SSLSecurityProtocol sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public boolean isValidateCertificates() {
        return this.validateCertificates;
    }

    public void setValidateCertificates(boolean validateCertificates) {
        this.validateCertificates = validateCertificates;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public void setStreaming(boolean streaming) {
        this.streaming = streaming;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
    }

    public boolean isUseSunHttpsHandler() {
        return this.useSunHttpsHandler;
    }

    public void setUseSunHttpsHandler(boolean useSunHttpsHandler) {
        this.useSunHttpsHandler = useSunHttpsHandler;
    }

    public String getSavedSearch() {
        return this.savedSearch;
    }

    public void setSavedSearch(String savedSearch) {
        this.savedSearch = savedSearch;
    }

    public SplunkConnectionFactory getConnectionFactory() {
        return this.connectionFactory != null ? this.connectionFactory : this.createDefaultConnectionFactory();
    }

    public void setConnectionFactory(SplunkConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    private SplunkConnectionFactory createDefaultConnectionFactory() {
        SplunkConnectionFactory splunkConnectionFactory = ObjectHelper.isNotEmpty((String)this.getHost()) && this.getPort() > 0 ? new SplunkConnectionFactory(this.getHost(), this.getPort(), this.getUsername(), this.getPassword()) : new SplunkConnectionFactory(this.getUsername(), this.getPassword());
        splunkConnectionFactory.setApp(this.getApp());
        splunkConnectionFactory.setConnectionTimeout(this.getConnectionTimeout());
        splunkConnectionFactory.setScheme(this.getScheme());
        splunkConnectionFactory.setUseSunHttpsHandler(this.isUseSunHttpsHandler());
        splunkConnectionFactory.setSslProtocol(this.getSslProtocol());
        splunkConnectionFactory.setValidateCertificates(this.isValidateCertificates());
        splunkConnectionFactory.setToken(this.getToken());
        return splunkConnectionFactory;
    }
}

