/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.splunk;

import com.splunk.HttpService;
import com.splunk.SSLSecurityProtocol;
import com.splunk.Service;
import com.splunk.ServiceArgs;
import java.net.URLStreamHandler;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplunkConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SplunkConnectionFactory.class);
    private String host;
    private int port;
    private String scheme;
    private String app;
    private String owner;
    private String username;
    private String password;
    private int connectionTimeout;
    private boolean useSunHttpsHandler;
    private SSLSecurityProtocol sslProtocol;

    public SplunkConnectionFactory(String host, int port, String username, String password) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public SplunkConnectionFactory(String username, String password) {
        this(Service.DEFAULT_HOST, Service.DEFAULT_PORT, username, password);
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public boolean isUseSunHttpsHandler() {
        return this.useSunHttpsHandler;
    }

    public void setUseSunHttpsHandler(boolean useSunHttpsHandler) {
        this.useSunHttpsHandler = useSunHttpsHandler;
    }

    public SSLSecurityProtocol getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(SSLSecurityProtocol sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public synchronized Service createService(CamelContext camelContext) {
        final ServiceArgs args = new ServiceArgs();
        if (this.host != null) {
            args.setHost(this.host);
        }
        if (this.port > 0) {
            args.setPort(this.port);
        }
        if (this.scheme != null) {
            args.setScheme(this.scheme);
        }
        if (this.app != null) {
            args.setApp(this.app);
        }
        if (this.owner != null) {
            args.setOwner(this.owner);
        }
        if (this.username != null) {
            args.setUsername(this.username);
        }
        if (this.password != null) {
            args.setPassword(this.password);
        }
        if (this.isUseSunHttpsHandler()) {
            String sunHandlerClassName = "sun.net.www.protocol.https.Handler";
            Class clazz = camelContext.getClassResolver().resolveClass(sunHandlerClassName, URLStreamHandler.class);
            if (clazz != null) {
                URLStreamHandler handler = (URLStreamHandler)camelContext.getInjector().newInstance(clazz);
                args.setHTTPSHandler(handler);
                LOG.debug("using the URLStreamHandler {} for {}", (Object)handler, (Object)args);
            } else {
                LOG.warn("could not resolve and use the URLStreamHandler class '{}'", (Object)sunHandlerClassName);
            }
        }
        ExecutorService executor = camelContext.getExecutorServiceManager().newSingleThreadExecutor((Object)this, "DefaultSplunkConnectionFactory");
        Future<Service> future = executor.submit(new Callable<Service>(){

            @Override
            public Service call() throws Exception {
                if (Service.DEFAULT_SCHEME.equals(SplunkConnectionFactory.this.getScheme())) {
                    LOG.debug("Https in use. Setting SSL protocol to {}", (Object)SplunkConnectionFactory.this.getSslProtocol());
                    HttpService.setSslSecurityProtocol((SSLSecurityProtocol)SplunkConnectionFactory.this.getSslProtocol());
                }
                return Service.connect((Map)args);
            }
        });
        try {
            Service service = null;
            service = this.connectionTimeout > 0 ? future.get(this.connectionTimeout, TimeUnit.MILLISECONDS) : future.get();
            LOG.info("Successfully connected to Splunk");
            Service service2 = service;
            return service2;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("could not connect to Splunk Server @ %s:%d - %s", this.host, this.port, e.getMessage()));
        }
        finally {
            if (executor != null) {
                camelContext.getExecutorServiceManager().shutdownNow(executor);
            }
        }
    }
}

