/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.splunk.event;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class SplunkEvent
implements Serializable {
    public static final String COMMON_CATEGORY = "category";
    public static final String COMMON_COUNT = "count";
    public static final String COMMON_DESC = "desc";
    public static final String COMMON_DHCP_POOL = "dhcp_pool";
    public static final String COMMON_DURATION = "duration";
    public static final String COMMON_DVC_HOST = "dvc_host";
    public static final String COMMON_DVC_IP = "dvc_ip";
    public static final String COMMON_DVC_IP6 = "dvc_ip6";
    public static final String COMMON_DVC_LOCATION = "dvc_location";
    public static final String COMMON_DVC_MAC = "dvc_mac";
    public static final String COMMON_DVC_NT_DOMAIN = "dvc_nt_domain";
    public static final String COMMON_DVC_NT_HOST = "dvc_nt_host";
    public static final String COMMON_DVC_TIME = "dvc_time";
    public static final String COMMON_END_TIME = "end_time";
    public static final String COMMON_EVENT_ID = "event_id";
    public static final String COMMON_LENGTH = "length";
    public static final String COMMON_LOG_LEVEL = "log_level";
    public static final String COMMON_NAME = "name";
    public static final String COMMON_PID = "pid";
    public static final String COMMON_PRIORITY = "priority";
    public static final String COMMON_PRODUCT = "product";
    public static final String COMMON_PRODUCT_VERSION = "product_version";
    public static final String COMMON_REASON = "reason";
    public static final String COMMON_RESULT = "result";
    public static final String COMMON_SEVERITY = "severity";
    public static final String COMMON_START_TIME = "start_time";
    public static final String COMMON_TRANSACTION_ID = "transaction_id";
    public static final String COMMON_URL = "url";
    public static final String COMMON_VENDOR = "vendor";
    public static final String UPDATE_PACKAGE = "package";
    private static final String KVDELIM = "=";
    private static final String PAIRDELIM = " ";
    private static final char QUOTE = '\"';
    private static final String DATEFORMATPATTERN = "yyyy-MM-dd\tHH:mm:ss:SSSZ";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd\tHH:mm:ss:SSSZ");
    private static final String PREFIX_NAME = "name";
    private static final String PREFIX_EVENT_ID = "event_id";
    private static final String THROWABLE_CLASS = "throwable_class";
    private static final String THROWABLE_MESSAGE = "throwable_message";
    private static final String THROWABLE_STACKTRACE_ELEMENTS = "stacktrace_elements";
    private static final String LINEBREAK = "\n";
    private boolean quoteValues = true;
    private boolean useInternalDate = true;
    private Map<String, String> event;

    public SplunkEvent(Map<String, String> data) {
        this.event = data;
    }

    public SplunkEvent(SplunkEvent splunkEvent) {
        this.event = splunkEvent.getEventData();
        this.quoteValues = splunkEvent.quoteValues;
        this.useInternalDate = splunkEvent.useInternalDate;
    }

    public SplunkEvent(String eventName, String eventID, boolean useInternalDate, boolean quoteValues) {
        this.event = new LinkedHashMap<String, String>();
        this.quoteValues = quoteValues;
        this.useInternalDate = useInternalDate;
        this.addPair("name", eventName);
        if (eventID != null) {
            this.addPair("event_id", eventID);
        }
    }

    public SplunkEvent(String eventName, String eventID) {
        this(eventName, eventID, true, true);
    }

    public SplunkEvent() {
        this.event = new LinkedHashMap<String, String>();
    }

    public Map<String, String> getEventData() {
        return this.event;
    }

    public void addPair(String key, char value) {
        this.addPair(key, String.valueOf(value));
    }

    public void addPair(String key, boolean value) {
        this.addPair(key, String.valueOf(value));
    }

    public void addPair(String key, double value) {
        this.addPair(key, String.valueOf(value));
    }

    public void addPair(String key, long value) {
        this.addPair(key, String.valueOf(value));
    }

    public void addPair(String key, int value) {
        this.addPair(key, String.valueOf(value));
    }

    public void addPair(String key, Object value) {
        this.addPair(key, value.toString());
    }

    public void addThrowable(Throwable throwable) {
        this.addThrowableObject(throwable, -1);
    }

    public void addThrowable(Throwable throwable, int stackTraceDepth) {
        this.addThrowableObject(throwable, stackTraceDepth);
    }

    private void addThrowableObject(Throwable throwable, int stackTraceDepth) {
        this.addPair(THROWABLE_CLASS, throwable.getClass().getCanonicalName());
        this.addPair(THROWABLE_MESSAGE, throwable.getMessage());
        StackTraceElement[] elements = throwable.getStackTrace();
        StringBuilder sb = new StringBuilder();
        int depth = 0;
        for (StackTraceElement element : elements) {
            if (stackTraceDepth != -1 && stackTraceDepth < ++depth) break;
            sb.append(element.toString()).append(",");
        }
        this.addPair(THROWABLE_STACKTRACE_ELEMENTS, sb.toString());
    }

    public void addPair(String key, String value) {
        this.event.put(key, value);
    }

    public String toString() {
        StringBuilder event = new StringBuilder();
        if (this.useInternalDate) {
            event.append(DATE_FORMATTER.print(new Date().getTime())).append(PAIRDELIM);
        }
        for (String key : this.event.keySet()) {
            event.append(key);
            event.append(KVDELIM);
            if (this.quoteValues) {
                event.append('\"').append(this.event.get(key)).append('\"').append(PAIRDELIM);
                continue;
            }
            event.append(this.event.get(key)).append(PAIRDELIM);
        }
        String result = event.substring(0, event.length() - PAIRDELIM.length()) + LINEBREAK;
        return result;
    }

    public void setCommonCategory(String commonCategory) {
        this.addPair(COMMON_CATEGORY, commonCategory);
    }

    public void setCommonCount(String commonCount) {
        this.addPair(COMMON_COUNT, commonCount);
    }

    public void setCommonDesc(String commonDesc) {
        this.addPair(COMMON_DESC, commonDesc);
    }

    public void setCommonDhcpPool(String commonDhcpPool) {
        this.addPair(COMMON_DHCP_POOL, commonDhcpPool);
    }

    public void setCommonDuration(long commonDuration) {
        this.addPair(COMMON_DURATION, commonDuration);
    }

    public void setCommonDvcHost(String commonDvcHost) {
        this.addPair(COMMON_DVC_HOST, commonDvcHost);
    }

    public void setCommonDvcIp(String commonDvcIp) {
        this.addPair(COMMON_DVC_IP, commonDvcIp);
    }

    public void setCommonDvcIp6(String commonDvcIp6) {
        this.addPair(COMMON_DVC_IP6, commonDvcIp6);
    }

    public void setCommonDvcLocation(String commonDvcLocation) {
        this.addPair(COMMON_DVC_LOCATION, commonDvcLocation);
    }

    public void setCommonDvcMac(String commonDvcMac) {
        this.addPair(COMMON_DVC_MAC, commonDvcMac);
    }

    public void setCommonDvcNtDomain(String commonDvcNtDomain) {
        this.addPair(COMMON_DVC_NT_DOMAIN, commonDvcNtDomain);
    }

    public void setCommonDvcNtHost(String commonDvcNtHost) {
        this.addPair(COMMON_DVC_NT_HOST, commonDvcNtHost);
    }

    public void setCommonDvcTime(long commonDvcTime) {
        this.addPair(COMMON_DVC_TIME, commonDvcTime);
    }

    public void setCommonEndTime(long commonEndTime) {
        this.addPair(COMMON_END_TIME, commonEndTime);
    }

    public void setCommonEventId(long commonEventId) {
        this.addPair("event_id", commonEventId);
    }

    public void setCommonLength(long commonLength) {
        this.addPair(COMMON_LENGTH, commonLength);
    }

    public void setCommonLogLevel(String commonLogLevel) {
        this.addPair(COMMON_LOG_LEVEL, commonLogLevel);
    }

    public void setCommonName(String commonName) {
        this.addPair("name", commonName);
    }

    public void setCommonPid(long commonPid) {
        this.addPair(COMMON_PID, commonPid);
    }

    public void setCommonPriority(long commonPriority) {
        this.addPair(COMMON_PRIORITY, commonPriority);
    }

    public void setCommonProduct(String commonProduct) {
        this.addPair(COMMON_PRODUCT, commonProduct);
    }

    public void setCommonProductVersion(long commonProductVersion) {
        this.addPair(COMMON_PRODUCT_VERSION, commonProductVersion);
    }

    public void setCommonReason(String commonReason) {
        this.addPair(COMMON_REASON, commonReason);
    }

    public void setCommonResult(String commonResult) {
        this.addPair(COMMON_RESULT, commonResult);
    }

    public void setCommonSeverity(String commonSeverity) {
        this.addPair(COMMON_SEVERITY, commonSeverity);
    }

    public void setCommonStartTime(long commonStartTime) {
        this.addPair(COMMON_START_TIME, commonStartTime);
    }

    public void setCommonTransactionId(String commonTransactionId) {
        this.addPair(COMMON_TRANSACTION_ID, commonTransactionId);
    }

    public void setCommonUrl(String commonUrl) {
        this.addPair(COMMON_URL, commonUrl);
    }

    public void setCommonVendor(String commonVendor) {
        this.addPair(COMMON_VENDOR, commonVendor);
    }

    public void setUpdatePackage(String updatePackage) {
        this.addPair(UPDATE_PACKAGE, updatePackage);
    }
}

