/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr.converter;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.solr.converter.SolrRequestConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.apache.solr.client.solrj.request.ContentStreamUpdateRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.SolrPing;
import org.apache.solr.client.solrj.request.UpdateRequest;

@DeferredContextBinding
public final class SolrRequestConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        SolrRequestConverterLoader.addTypeConverter(registry, ContentStreamUpdateRequest.class, Object.class, false, (type, exchange, value) -> {
            ContentStreamUpdateRequest answer = SolrRequestConverter.createContentStreamUpdateRequest(value, exchange);
            return answer;
        });
        SolrRequestConverterLoader.addTypeConverter(registry, QueryRequest.class, Object.class, false, (type, exchange, value) -> {
            QueryRequest answer = SolrRequestConverter.createQueryRequest(value, exchange);
            return answer;
        });
        SolrRequestConverterLoader.addTypeConverter(registry, SolrPing.class, Object.class, false, (type, exchange, value) -> {
            SolrPing answer = SolrRequestConverter.createSolrPing(value, exchange);
            return answer;
        });
        SolrRequestConverterLoader.addTypeConverter(registry, UpdateRequest.class, Object.class, false, (type, exchange, value) -> {
            UpdateRequest answer = SolrRequestConverter.createUpdateRequest(value, exchange);
            return answer;
        });
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

