/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import java.io.IOException;
import java.util.Map;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.DefaultComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorHelper;
import org.apache.camel.component.solr.SolrConfiguration;
import org.apache.solr.client.solrj.impl.HttpJdkSolrClient;

public class SolrComponentVerifierExtension
extends DefaultComponentVerifierExtension {
    public SolrComponentVerifierExtension() {
        this("solr");
    }

    public SolrComponentVerifierExtension(String scheme) {
        super(scheme);
    }

    protected ComponentVerifierExtension.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.PARAMETERS).error(ResultErrorHelper.requiresOption(parameters, (String)"host"));
        super.verifyParametersAgainstCatalog(builder, parameters);
        return builder.build();
    }

    protected ComponentVerifierExtension.Result verifyConnectivity(Map<String, Object> parameters) {
        ResultBuilder builder;
        block10: {
            builder = ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.CONNECTIVITY);
            try {
                SolrConfiguration configuration = (SolrConfiguration)this.setProperties(new SolrConfiguration(), parameters);
                if (configuration.getSolrClient() != null) {
                    configuration.getSolrClient().ping();
                    break block10;
                }
                try (HttpJdkSolrClient client = SolrComponentVerifierExtension.getDefaultSolrClientBuilder(configuration).build();){
                    client.ping();
                }
            }
            catch (IOException e) {
                ResultErrorBuilder errorBuilder = ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, (String)e.getMessage()).detail("solr_exception_message", (Object)e.getMessage()).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_CLASS, (Object)e.getClass().getName()).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_INSTANCE, (Object)e);
                builder.error(errorBuilder.build());
            }
            catch (Exception e) {
                builder.error(ResultErrorBuilder.withException((Exception)e).build());
            }
        }
        return builder.build();
    }

    private static HttpJdkSolrClient.Builder getDefaultSolrClientBuilder(SolrConfiguration configuration) {
        HttpJdkSolrClient.Builder builder = new HttpJdkSolrClient.Builder(configuration.getSolrBaseUrl());
        builder.withDefaultCollection(configuration.getCollection());
        return builder;
    }
}

