/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smooks;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.component.smooks.SmooksProcessor;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.ProcessorEndpoint;
import org.apache.camel.support.service.ServiceHelper;

@UriEndpoint(firstVersion="4.7.0", scheme="smooks", title="Smooks", syntax="smooks:smooksConfig", category={Category.TRANSFORMATION})
public class SmooksEndpoint
extends ProcessorEndpoint {
    @UriPath(description="Smooks XML configuration file")
    @Metadata(required=true, supportFileReference=true)
    private String smooksConfig;
    private final SmooksProcessor smooksProcessor;

    public SmooksEndpoint(String endpointUri, Component component, SmooksProcessor processor) {
        super(endpointUri, component, (Processor)processor);
        this.smooksProcessor = processor;
    }

    public String getSmooksConfig() {
        return this.smooksConfig;
    }

    public void setSmooksConfig(String smooksConfig) {
        this.smooksConfig = smooksConfig;
    }

    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Service)this.smooksProcessor);
    }

    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Service)this.smooksProcessor);
    }
}

