/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.smooks;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConverter;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.smooks.Smooks;
import org.smooks.SmooksFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.io.Sink;
import org.smooks.api.io.Source;
import org.smooks.engine.lookup.ExportsLookup;
import org.smooks.io.payload.Exports;
import org.smooks.io.sink.StringSink;
import org.smooks.io.source.JavaSource;
import org.smooks.io.source.StreamSource;
import org.xml.sax.SAXException;

@Dataformat(value="smooks")
public class SmooksDataFormat
extends ServiceSupport
implements DataFormat,
CamelContextAware {
    private Smooks smooks;
    private CamelContext camelContext;
    private String smooksConfig;

    public void marshal(Exchange exchange, Object fromBody, OutputStream toStream) throws Exception {
        ExecutionContext executionContext = this.smooks.createExecutionContext();
        TypeConverter typeConverter = exchange.getContext().getTypeConverter();
        JavaSource javaSource = (JavaSource)typeConverter.mandatoryConvertTo(JavaSource.class, exchange, fromBody);
        StringSink stringSink = new StringSink();
        this.smooks.filterSource(executionContext, (Source)javaSource, new Sink[]{stringSink});
        toStream.write(stringSink.getResult().getBytes(executionContext.getContentEncoding()));
    }

    public Object unmarshal(Exchange exchange, InputStream fromStream) {
        ExecutionContext executionContext = this.smooks.createExecutionContext();
        Exports exports = (Exports)this.smooks.getApplicationContext().getRegistry().lookup((Function)new ExportsLookup());
        Sink[] sinks = exports.createSinks();
        this.smooks.filterSource(executionContext, (Source)new StreamSource(fromStream), sinks);
        return this.getResult(exports, sinks, exchange);
    }

    protected Object getResult(Exports exports, Sink[] sinks, Exchange exchange) {
        List objects = Exports.extractSinks((Sink[])sinks, (Exports)exports);
        if (objects.size() == 1) {
            return objects.get(0);
        }
        return objects;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void doStart() {
        SmooksFactory smooksFactory = (SmooksFactory)CamelContextHelper.findSingleByType((CamelContext)this.camelContext, SmooksFactory.class);
        try {
            this.smooks = smooksFactory != null ? smooksFactory.createInstance(this.smooksConfig) : new Smooks(this.smooksConfig);
        }
        catch (IOException | SAXException e) {
            throw new SmooksException(e.getMessage(), (Throwable)e);
        }
    }

    public void doStop() {
        if (this.smooks != null) {
            this.smooks.close();
        }
    }

    public String getSmooksConfig() {
        return this.smooksConfig;
    }

    public void setSmooksConfig(String smooksConfig) {
        this.smooksConfig = smooksConfig;
    }
}

