/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smooks.converter;

import java.io.File;
import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.smooks.converter.SourceConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.smooks.api.io.Source;
import org.smooks.io.sink.JavaSink;
import org.smooks.io.source.JavaSource;
import org.smooks.io.source.JavaSourceWithoutEventStream;
import org.smooks.io.source.StreamSource;
import org.smooks.io.source.StringSource;

@DeferredContextBinding
public final class SourceConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        SourceConverterLoader.addTypeConverter(registry, Source.class, WrappedFile.class, false, (type, exchange, value) -> {
            Source answer = SourceConverter.toURISource((WrappedFile<File>)((WrappedFile)value));
            return answer;
        });
        SourceConverterLoader.addTypeConverter(registry, JavaSource.class, Object.class, false, (type, exchange, value) -> {
            JavaSource answer = SourceConverter.toJavaSource(value);
            return answer;
        });
        SourceConverterLoader.addTypeConverter(registry, JavaSource.class, JavaSink.class, false, (type, exchange, value) -> {
            JavaSource answer = SourceConverter.toJavaSource((JavaSink)value);
            return answer;
        });
        SourceConverterLoader.addTypeConverter(registry, JavaSourceWithoutEventStream.class, Object.class, false, (type, exchange, value) -> {
            JavaSourceWithoutEventStream answer = SourceConverter.toJavaSourceWithoutEventStream(value);
            return answer;
        });
        SourceConverterLoader.addTypeConverter(registry, StreamSource.class, InputStream.class, false, (type, exchange, value) -> {
            StreamSource answer = SourceConverter.toStreamSource((InputStream)value);
            return answer;
        });
        SourceConverterLoader.addTypeConverter(registry, StringSource.class, String.class, false, (type, exchange, value) -> {
            StringSource answer = SourceConverter.toStringSource((String)value);
            return answer;
        });
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

