/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.shiro.security;

import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelAuthorizationException;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.shiro.security.ShiroSecurityHelper;
import org.apache.camel.component.shiro.security.ShiroSecurityPolicy;
import org.apache.camel.component.shiro.security.ShiroSecurityToken;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.apache.camel.util.ObjectHelper;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ByteSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroSecurityProcessor
extends DelegateAsyncProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ShiroSecurityProcessor.class);
    private final ShiroSecurityPolicy policy;

    public ShiroSecurityProcessor(Processor processor, ShiroSecurityPolicy policy) {
        super(processor);
        this.policy = policy;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.applySecurityPolicy(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        return super.process(exchange, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applySecurityPolicy(Exchange exchange) throws Exception {
        ByteSource encryptedToken;
        Object token;
        String username = (String)exchange.getIn().getHeader("SHIRO_SECURITY_USERNAME", String.class);
        String password = (String)exchange.getIn().getHeader("SHIRO_SECURITY_PASSWORD", String.class);
        if (username != null && password != null) {
            token = new ShiroSecurityToken(username, password);
            if (this.policy.isBase64()) {
                ByteSource bytes = ShiroSecurityHelper.encrypt((ShiroSecurityToken)token, this.policy.getPassPhrase(), this.policy.getCipherService());
                String base64 = bytes.toBase64();
                exchange.getIn().setHeader("SHIRO_SECURITY_TOKEN", (Object)base64);
            } else {
                exchange.getIn().setHeader("SHIRO_SECURITY_TOKEN", token);
            }
            exchange.getIn().removeHeader("SHIRO_SECURITY_USERNAME");
            exchange.getIn().removeHeader("SHIRO_SECURITY_PASSWORD");
        }
        if ((token = ExchangeHelper.getMandatoryHeader((Exchange)exchange, (String)"SHIRO_SECURITY_TOKEN", Object.class)) instanceof ShiroSecurityToken) {
            ShiroSecurityToken sst = (ShiroSecurityToken)token;
            encryptedToken = ShiroSecurityHelper.encrypt(sst, this.policy.getPassPhrase(), this.policy.getCipherService());
            exchange.getIn().removeHeader("SHIRO_SECURITY_TOKEN");
            exchange.getIn().setHeader("SHIRO_SECURITY_TOKEN", (Object)encryptedToken);
        } else if (token instanceof String) {
            String data = (String)token;
            if (this.policy.isBase64()) {
                byte[] bytes = Base64.decode((String)data);
                encryptedToken = ByteSource.Util.bytes((byte[])bytes);
            } else {
                encryptedToken = ByteSource.Util.bytes((String)data);
            }
        } else if (token instanceof ByteSource) {
            encryptedToken = (ByteSource)token;
        } else {
            throw new CamelExchangeException("Shiro security header SHIRO_SECURITY_TOKEN is unsupported type: " + ObjectHelper.classCanonicalName((Object)token), exchange);
        }
        ByteSource decryptedToken = this.policy.getCipherService().decrypt(encryptedToken.getBytes(), this.policy.getPassPhrase());
        ShiroSecurityToken securityToken = ShiroSecurityHelper.deserialize(decryptedToken.getBytes());
        Subject currentUser = SecurityUtils.getSubject();
        try {
            this.authenticateUser(currentUser, securityToken);
            this.authorizeUser(currentUser, exchange);
        }
        finally {
            if (this.policy.isAlwaysReauthenticate()) {
                currentUser.logout();
            }
        }
    }

    private void authenticateUser(Subject currentUser, ShiroSecurityToken securityToken) {
        boolean authenticated = currentUser.isAuthenticated();
        boolean sameUser = securityToken.getUsername().equals(currentUser.getPrincipal());
        LOG.trace("Authenticated: {}, same Username: {}", (Object)authenticated, (Object)sameUser);
        if (!authenticated || !sameUser) {
            UsernamePasswordToken token = new UsernamePasswordToken(securityToken.getUsername(), securityToken.getPassword());
            if (this.policy.isAlwaysReauthenticate()) {
                token.setRememberMe(false);
            } else {
                token.setRememberMe(true);
            }
            try {
                currentUser.login((AuthenticationToken)token);
                LOG.debug("Current user {} successfully authenticated", currentUser.getPrincipal());
            }
            catch (UnknownAccountException uae) {
                throw new UnknownAccountException("Authentication Failed. There is no user with username of " + token.getPrincipal(), uae.getCause());
            }
            catch (IncorrectCredentialsException ice) {
                throw new IncorrectCredentialsException("Authentication Failed. Password for account " + token.getPrincipal() + " was incorrect!", ice.getCause());
            }
            catch (LockedAccountException lae) {
                throw new LockedAccountException("Authentication Failed. The account for username " + token.getPrincipal() + " is locked. Please contact your administrator to unlock it.", lae.getCause());
            }
            catch (AuthenticationException ae) {
                throw new AuthenticationException("Authentication Failed.", ae.getCause());
            }
        }
    }

    private void authorizeUser(Subject currentUser, Exchange exchange) throws CamelAuthorizationException {
        boolean authorized = false;
        if (!this.policy.getPermissionsList().isEmpty()) {
            if (this.policy.isAllPermissionsRequired()) {
                authorized = currentUser.isPermittedAll(this.policy.getPermissionsList());
            } else {
                for (Permission permission : this.policy.getPermissionsList()) {
                    if (!currentUser.isPermitted(permission)) continue;
                    authorized = true;
                    break;
                }
            }
        } else if (!this.policy.getRolesList().isEmpty()) {
            if (this.policy.isAllRolesRequired()) {
                authorized = currentUser.hasAllRoles(this.policy.getRolesList());
            } else {
                for (String role : this.policy.getRolesList()) {
                    if (!currentUser.hasRole(role)) continue;
                    authorized = true;
                    break;
                }
            }
        } else {
            LOG.trace("Valid Permissions or Roles List not specified for ShiroSecurityPolicy. No authorization checks will be performed for current user.");
            authorized = true;
        }
        if (!authorized) {
            throw new CamelAuthorizationException("Authorization Failed. Subject's role set does not have the necessary roles or permissions to perform further processing.", exchange);
        }
        LOG.debug("Current user {} is successfully authorized.", currentUser.getPrincipal());
    }
}

