/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.shiro.security;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.component.shiro.security.ShiroSecurityProcessor;
import org.apache.camel.spi.AuthorizationPolicy;
import org.apache.camel.spi.RouteContext;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.config.Ini;
import org.apache.shiro.config.IniSecurityManagerFactory;
import org.apache.shiro.crypto.AesCipherService;
import org.apache.shiro.crypto.CipherService;
import org.apache.shiro.mgt.SecurityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroSecurityPolicy
implements AuthorizationPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(ShiroSecurityPolicy.class);
    private final byte[] bits128 = new byte[]{8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    private CipherService cipherService;
    private byte[] passPhrase = this.bits128;
    private SecurityManager securityManager;
    private List<Permission> permissionsList;
    private List<String> rolesList;
    private boolean alwaysReauthenticate = true;
    private boolean base64;
    private boolean allPermissionsRequired;
    private boolean allRolesRequired;

    public ShiroSecurityPolicy() {
        this.cipherService = new AesCipherService();
        this.permissionsList = new ArrayList<Permission>();
        this.rolesList = new ArrayList<String>();
    }

    public ShiroSecurityPolicy(String iniResourcePath) {
        this();
        IniSecurityManagerFactory factory = new IniSecurityManagerFactory(iniResourcePath);
        this.securityManager = (SecurityManager)factory.getInstance();
        SecurityUtils.setSecurityManager((SecurityManager)this.securityManager);
    }

    public ShiroSecurityPolicy(Ini ini) {
        this();
        IniSecurityManagerFactory factory = new IniSecurityManagerFactory(ini);
        this.securityManager = (SecurityManager)factory.getInstance();
        SecurityUtils.setSecurityManager((SecurityManager)this.securityManager);
    }

    public ShiroSecurityPolicy(String iniResourcePath, byte[] passPhrase) {
        this(iniResourcePath);
        this.setPassPhrase(passPhrase);
    }

    public ShiroSecurityPolicy(Ini ini, byte[] passPhrase) {
        this(ini);
        this.setPassPhrase(passPhrase);
    }

    public ShiroSecurityPolicy(String iniResourcePath, byte[] passPhrase, boolean alwaysReauthenticate) {
        this(iniResourcePath, passPhrase);
        this.setAlwaysReauthenticate(alwaysReauthenticate);
    }

    public ShiroSecurityPolicy(Ini ini, byte[] passPhrase, boolean alwaysReauthenticate) {
        this(ini, passPhrase);
        this.setAlwaysReauthenticate(alwaysReauthenticate);
    }

    public ShiroSecurityPolicy(String iniResourcePath, byte[] passPhrase, boolean alwaysReauthenticate, List<Permission> permissionsList) {
        this(iniResourcePath, passPhrase, alwaysReauthenticate);
        this.setPermissionsList(permissionsList);
    }

    public ShiroSecurityPolicy(Ini ini, byte[] passPhrase, boolean alwaysReauthenticate, List<Permission> permissionsList) {
        this(ini, passPhrase, alwaysReauthenticate);
        this.setPermissionsList(permissionsList);
    }

    public void beforeWrap(RouteContext routeContext, NamedNode definition) {
    }

    public Processor wrap(RouteContext routeContext, Processor processor) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Securing route {} using Shiro policy {}", (Object)routeContext.getRoute().getId(), (Object)this);
        }
        return new ShiroSecurityProcessor(processor, this);
    }

    public CipherService getCipherService() {
        return this.cipherService;
    }

    public void setCipherService(CipherService cipherService) {
        this.cipherService = cipherService;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public byte[] getPassPhrase() {
        return this.passPhrase;
    }

    public void setPassPhrase(byte[] passPhrase) {
        this.passPhrase = passPhrase;
    }

    public List<Permission> getPermissionsList() {
        return this.permissionsList;
    }

    public void setPermissionsList(List<Permission> permissionsList) {
        this.permissionsList = permissionsList;
    }

    public boolean isAlwaysReauthenticate() {
        return this.alwaysReauthenticate;
    }

    public void setAlwaysReauthenticate(boolean alwaysReauthenticate) {
        this.alwaysReauthenticate = alwaysReauthenticate;
    }

    public boolean isBase64() {
        return this.base64;
    }

    public void setBase64(boolean base64) {
        this.base64 = base64;
    }

    public boolean isAllPermissionsRequired() {
        return this.allPermissionsRequired;
    }

    public void setAllPermissionsRequired(boolean allPermissionsRequired) {
        this.allPermissionsRequired = allPermissionsRequired;
    }

    public List<String> getRolesList() {
        return this.rolesList;
    }

    public void setRolesList(List<String> rolesList) {
        this.rolesList = rolesList;
    }

    public boolean isAllRolesRequired() {
        return this.allRolesRequired;
    }

    public void setAllRolesRequired(boolean allRolesRequired) {
        this.allRolesRequired = allRolesRequired;
    }
}

