/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.shiro.security;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.shiro.security.ShiroSecurityToken;
import org.apache.camel.util.IOHelper;
import org.apache.shiro.crypto.AesCipherService;
import org.apache.shiro.crypto.CipherService;
import org.apache.shiro.util.ByteSource;

public class ShiroSecurityTokenInjector
implements Processor {
    private final byte[] bits128 = new byte[]{8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    private byte[] passPhrase = this.bits128;
    private ShiroSecurityToken securityToken;
    private CipherService cipherService = new AesCipherService();

    public ShiroSecurityTokenInjector() {
    }

    public ShiroSecurityTokenInjector(ShiroSecurityToken securityToken, byte[] passPhrase) {
        this();
        this.setSecurityToken(securityToken);
        this.setPassPhrase(passPhrase);
    }

    public ShiroSecurityTokenInjector(ShiroSecurityToken securityToken, byte[] passPhrase, CipherService cipherService) {
        this(securityToken, passPhrase);
        this.cipherService = cipherService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteSource encrypt() throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ObjectOutputStream serialStream = new ObjectOutputStream(stream);
        try {
            serialStream.writeObject(this.securityToken);
            ByteSource byteSource = this.cipherService.encrypt(stream.toByteArray(), this.passPhrase);
            return byteSource;
        }
        finally {
            ShiroSecurityTokenInjector.close(serialStream);
            IOHelper.close((Closeable)stream);
        }
    }

    public void process(Exchange exchange) throws Exception {
        exchange.getIn().setHeader("SHIRO_SECURITY_TOKEN", (Object)this.encrypt());
    }

    public byte[] getPassPhrase() {
        return this.passPhrase;
    }

    public void setPassPhrase(byte[] passPhrase) {
        this.passPhrase = passPhrase;
    }

    public void setSecurityToken(ShiroSecurityToken securityToken) {
        this.securityToken = securityToken;
    }

    public ShiroSecurityToken getSecurityToken() {
        return this.securityToken;
    }

    public CipherService getCipherService() {
        return this.cipherService;
    }

    public void setCipherService(CipherService cipherService) {
        this.cipherService = cipherService;
    }

    private static void close(ObjectOutput output) {
        try {
            output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

