/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow.releases.helsinki;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.servicenow.AbstractServiceNowProcessor;
import org.apache.camel.component.servicenow.ServiceNowEndpoint;
import org.apache.camel.component.servicenow.ServiceNowParams;

class HelsinkiServiceNowMiscProcessor
extends AbstractServiceNowProcessor {
    HelsinkiServiceNowMiscProcessor(ServiceNowEndpoint endpoint) throws Exception {
        super(endpoint);
        this.addDispatcher("retrieve", "user_role_inheritance", this::retrieveUserRoleInheritance);
        this.addDispatcher("create", "identify_reconcile", this::uploadIdentifyReconcile);
    }

    private void retrieveUserRoleInheritance(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        Class<?> responseModel = this.getResponseModel(in);
        Response response = this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("global").path("user_role_inheritance").query(ServiceNowParams.PARAM_USER_SYS_ID, in).query(responseModel).invoke("GET");
        this.setBodyAndHeaders(in, responseModel, response);
    }

    private void uploadIdentifyReconcile(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        Class<?> responseModel = this.getResponseModel(in);
        String apiVersion = this.getApiVersion(in);
        Response response = this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(apiVersion).path("identifyreconcile").query(ServiceNowParams.SYSPARM_DATA_SOURCE, in).query(responseModel).invoke("POST", in.getMandatoryBody());
        this.setBodyAndHeaders(in, responseModel, response);
    }
}

