/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.script;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.script.ScriptEvaluationException;
import org.apache.camel.builder.script.ScriptPropertiesFunction;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptBuilder
implements Expression,
Predicate,
Processor {
    public static final String ARGUMENTS = "CamelScriptArguments";
    private static final Logger LOG = LoggerFactory.getLogger(ScriptBuilder.class);
    private Map<String, Object> attributes;
    private final CamelContext camelContext;
    private final ScriptEngineFactory scriptEngineFactory;
    private final String scriptLanguage;
    private final String scriptResource;
    private final String scriptText;
    private CompiledScript compiledScript;

    public ScriptBuilder(String scriptLanguage, String scriptText) {
        this(null, scriptLanguage, scriptText, null);
    }

    public ScriptBuilder(CamelContext camelContext, String scriptLanguage, String scriptText) {
        this(camelContext, scriptLanguage, scriptText, null);
    }

    public ScriptBuilder(CamelContext camelContext, String scriptLanguage, String scriptText, ScriptEngineFactory scriptEngineFactory) {
        this.camelContext = camelContext;
        this.scriptLanguage = scriptLanguage;
        if (ResourceHelper.hasScheme((String)scriptText)) {
            this.scriptResource = scriptText;
            this.scriptText = null;
        } else {
            this.scriptResource = null;
            this.scriptText = scriptText;
        }
        this.scriptEngineFactory = scriptEngineFactory == null ? ScriptBuilder.lookupScriptEngineFactory(scriptLanguage) : scriptEngineFactory;
        if (this.scriptEngineFactory == null) {
            throw new IllegalArgumentException("Cannot lookup ScriptEngineFactory for script language: " + scriptLanguage);
        }
        if (ScriptBuilder.isBeanShell(scriptLanguage)) {
            return;
        }
        Reader reader = null;
        try {
            ScriptEngine engine;
            if (camelContext != null && this.scriptResource != null) {
                reader = ScriptBuilder.createScriptReader(camelContext.getClassResolver(), this.scriptResource);
            } else if (this.scriptText != null) {
                reader = new StringReader(this.scriptText);
            }
            if (reader != null && (engine = this.scriptEngineFactory.getScriptEngine()) instanceof Compilable) {
                Compilable compilable = (Compilable)((Object)engine);
                this.compiledScript = compilable.compile(scriptText);
                LOG.debug("Using compiled script: {}", (Object)this.compiledScript);
            }
        }
        catch (IOException e) {
            throw new ScriptEvaluationException("Cannot load " + scriptLanguage + " script from resource: " + this.scriptResource, e);
        }
        catch (ScriptException e) {
            throw new ScriptEvaluationException("Error compiling " + scriptLanguage + " script: " + scriptText, e);
        }
        finally {
            IOHelper.close(reader);
        }
    }

    public String toString() {
        return this.getScriptDescription();
    }

    public Object evaluate(Exchange exchange) {
        return this.evaluateScript(exchange);
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        Object result = this.evaluate(exchange);
        return (T)exchange.getContext().getTypeConverter().convertTo(type, result);
    }

    public boolean matches(Exchange exchange) {
        Object scriptValue = this.evaluateScript(exchange);
        return this.matches(exchange, scriptValue);
    }

    public void assertMatches(String text, Exchange exchange) throws AssertionError {
        Object scriptValue = this.evaluateScript(exchange);
        if (!this.matches(exchange, scriptValue)) {
            throw new AssertionError((Object)(this + " failed on " + exchange + " as script returned <" + scriptValue + ">"));
        }
    }

    public void process(Exchange exchange) {
        this.evaluateScript(exchange);
    }

    public ScriptBuilder attribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(name, value);
        return this;
    }

    public static ScriptBuilder script(String language, String scriptText) {
        return new ScriptBuilder(language, scriptText);
    }

    public static ScriptBuilder groovy(String scriptText) {
        return new ScriptBuilder("groovy", scriptText);
    }

    public static ScriptBuilder javaScript(String scriptText) {
        return new ScriptBuilder("js", scriptText);
    }

    public static ScriptBuilder php(String scriptText) {
        return new ScriptBuilder("php", scriptText);
    }

    public static ScriptBuilder python(String scriptText) {
        return new ScriptBuilder("python", scriptText);
    }

    public static ScriptBuilder ruby(String scriptText) {
        return new ScriptBuilder("jruby", scriptText);
    }

    public CompiledScript getCompiledScript() {
        return this.compiledScript;
    }

    public String getScriptLanguage() {
        return this.scriptLanguage;
    }

    public String getScriptDescription() {
        if (this.scriptText != null) {
            return this.scriptLanguage + ": " + this.scriptText;
        }
        if (this.scriptResource != null) {
            return this.scriptLanguage + ": " + this.scriptResource;
        }
        return this.scriptLanguage + ": null script";
    }

    protected boolean matches(Exchange exchange, Object scriptValue) {
        return (Boolean)exchange.getContext().getTypeConverter().convertTo(Boolean.TYPE, scriptValue);
    }

    private static String[] getScriptNames(String name) {
        if (name.equals("js")) {
            return new String[]{"js", "javaScript", "ECMAScript"};
        }
        if (name.equals("javaScript")) {
            return new String[]{"javaScript", "js", "ECMAScript"};
        }
        if (name.equals("ECMAScript")) {
            return new String[]{"ECMAScript", "javaScript", "js"};
        }
        return new String[]{name};
    }

    protected static ScriptEngineFactory lookupScriptEngineFactory(String language) {
        ScriptEngineManager manager = new ScriptEngineManager();
        for (ScriptEngineFactory factory : manager.getEngineFactories()) {
            String[] names;
            for (String name : names = ScriptBuilder.getScriptNames(language)) {
                if (!factory.getLanguageName().equals(name)) continue;
                return factory;
            }
        }
        ScriptEngine engine = ScriptBuilder.createScriptEngine(language);
        if (engine != null) {
            return engine.getFactory();
        }
        return null;
    }

    protected static ScriptEngine createScriptEngine(String language) {
        String[] names;
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = null;
        for (String name : names = ScriptBuilder.getScriptNames(language)) {
            try {
                engine = manager.getEngineByName(name);
                if (engine == null) continue;
                break;
            }
            catch (NoClassDefFoundError ex) {
                LOG.error("Cannot load the scriptEngine for " + name + ", the exception is " + ex + ", please ensure correct JARs is provided on classpath.");
            }
        }
        if (engine == null) {
            engine = ScriptBuilder.checkForOSGiEngine(language);
        }
        if (engine == null) {
            throw new IllegalArgumentException("No script engine could be created for: " + language);
        }
        if (ScriptBuilder.isPython(language)) {
            ScriptContext context = engine.getContext();
            context.setAttribute("com.sun.script.jython.comp.mode", "eval", 100);
        }
        return engine;
    }

    private static ScriptEngine checkForOSGiEngine(String language) {
        LOG.debug("No script engine found for " + language + " using standard javax.script auto-registration. Checking OSGi registry...");
        try {
            Class<?> c = Class.forName("org.apache.camel.script.osgi.Activator");
            Method mth = c.getDeclaredMethod("getBundleContext", new Class[0]);
            Object ctx = mth.invoke(null, new Object[0]);
            LOG.debug("Found OSGi BundleContext " + ctx);
            if (ctx != null) {
                Method resolveScriptEngine = c.getDeclaredMethod("resolveScriptEngine", String.class);
                return (ScriptEngine)resolveScriptEngine.invoke(null, language);
            }
        }
        catch (Throwable t) {
            LOG.debug("Unable to load OSGi, script engine cannot be found", t);
        }
        return null;
    }

    protected Object evaluateScript(Exchange exchange) {
        try {
            ScriptEngine engine = this.scriptEngineFactory.getScriptEngine();
            ScriptContext context = this.populateBindings(engine, exchange, this.attributes);
            this.addScriptEngineArguments(engine, exchange);
            Object result = this.runScript(engine, exchange, context);
            LOG.debug("The script evaluation result is: {}", result);
            return result;
        }
        catch (ScriptException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Script evaluation failed: " + e.getMessage(), (Throwable)e);
            }
            if (e.getCause() != null) {
                throw this.createScriptEvaluationException(e.getCause());
            }
            throw this.createScriptEvaluationException(e);
        }
        catch (IOException e) {
            throw this.createScriptEvaluationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object runScript(ScriptEngine engine, Exchange exchange, ScriptContext context) throws ScriptException, IOException {
        Object result = null;
        if (this.compiledScript != null) {
            LOG.trace("Evaluate using compiled script for context: {} on exchange: {}", (Object)context, (Object)exchange);
            result = this.compiledScript.eval(context);
        } else if (this.scriptText != null) {
            LOG.trace("Evaluate script for context: {} on exchange: {}", (Object)context, (Object)exchange);
            result = engine.eval(this.scriptText, context);
        } else if (this.scriptResource != null) {
            InputStreamReader reader = ScriptBuilder.createScriptReader(exchange.getContext().getClassResolver(), this.scriptResource);
            try {
                LOG.trace("Evaluate script for context: {} on exchange: {}", (Object)context, (Object)exchange);
                result = engine.eval((Reader)reader, context);
            }
            finally {
                IOHelper.close((Closeable)reader);
            }
        }
        return result;
    }

    protected ScriptContext populateBindings(ScriptEngine engine, Exchange exchange, Map<String, Object> attributes) {
        ScriptContext context = engine.getContext();
        int scope = 100;
        context.setAttribute("context", exchange.getContext(), scope);
        context.setAttribute("camelContext", exchange.getContext(), scope);
        context.setAttribute("exchange", exchange, scope);
        Message in = exchange.getIn();
        context.setAttribute("request", in, scope);
        context.setAttribute("headers", in.getHeaders(), scope);
        context.setAttribute("body", in.getBody(), scope);
        if (exchange.hasOut()) {
            Message out = exchange.getOut();
            context.setAttribute("out", out, scope);
            context.setAttribute("response", out, scope);
        }
        context.setAttribute("properties", new ScriptPropertiesFunction(exchange.getContext()), scope);
        if (attributes != null) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                context.setAttribute(entry.getKey(), entry.getValue(), scope);
            }
        }
        return context;
    }

    protected void addScriptEngineArguments(ScriptEngine engine, Exchange exchange) {
        if (!exchange.getIn().hasHeaders()) {
            return;
        }
        Map args = (Map)exchange.getIn().getHeader(ARGUMENTS, Map.class);
        if (args != null) {
            for (Map.Entry entry : args.entrySet()) {
                String key = (String)exchange.getContext().getTypeConverter().convertTo(String.class, entry.getKey());
                Object value = entry.getValue();
                if (ObjectHelper.isEmpty((Object)key) || value == null) continue;
                LOG.trace("Putting {} -> {} on ScriptEngine", (Object)key, value);
                engine.put(key, value);
            }
        }
    }

    protected static InputStreamReader createScriptReader(ClassResolver classResolver, String resource) throws IOException {
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((ClassResolver)classResolver, (String)resource);
        return new InputStreamReader(is);
    }

    protected ScriptEvaluationException createScriptEvaluationException(Throwable e) {
        if (e.getClass().getName().equals("org.jruby.exceptions.RaiseException")) {
            try {
                Object ex = e.getClass().getMethod("getException", new Class[0]).invoke((Object)e, new Object[0]);
                return new ScriptEvaluationException("Failed to evaluate: " + this.getScriptDescription() + ".  Error: " + ex + ". Cause: " + e, e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ScriptEvaluationException("Failed to evaluate: " + this.getScriptDescription() + ". Cause: " + e, e);
    }

    private static boolean isPython(String language) {
        return "python".equals(language) || "jython".equals(language);
    }

    private static boolean isBeanShell(String language) {
        return "beanshell".equals(language) || "bsh".equals(language);
    }
}

