/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.parser.helper.CamelJavaParserHelper;
import org.apache.camel.parser.helper.CamelJavaRestDslParserHelper;
import org.apache.camel.parser.model.RestConfigurationDetails;
import org.apache.camel.parser.model.RestServiceDetails;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public final class RestDslParser {
    private RestDslParser() {
    }

    public static List<RestConfigurationDetails> parseRestConfiguration(JavaClassSource clazz, String fullyQualifiedFileName, boolean includeInlinedRouteBuilders) {
        List<MethodSource<JavaClassSource>> inlinedMethods;
        ArrayList<MethodSource<JavaClassSource>> methods = new ArrayList<MethodSource<JavaClassSource>>();
        MethodSource<JavaClassSource> method = CamelJavaParserHelper.findConfigureMethod(clazz);
        if (method != null) {
            methods.add(method);
        }
        if (includeInlinedRouteBuilders && !(inlinedMethods = CamelJavaParserHelper.findInlinedConfigureMethods(clazz)).isEmpty()) {
            methods.addAll(inlinedMethods);
        }
        CamelJavaRestDslParserHelper parser = new CamelJavaRestDslParserHelper();
        ArrayList<RestConfigurationDetails> list = new ArrayList<RestConfigurationDetails>();
        for (MethodSource methodSource : methods) {
            List<RestConfigurationDetails> details = parser.parseRestConfiguration(clazz, fullyQualifiedFileName, (MethodSource<JavaClassSource>)methodSource);
            list.addAll(details);
        }
        Collections.reverse(list);
        return list;
    }

    public static List<RestServiceDetails> parseRestService(JavaClassSource clazz, String fullyQualifiedFileName, boolean includeInlinedRouteBuilders) {
        List<MethodSource<JavaClassSource>> inlinedMethods;
        ArrayList<MethodSource<JavaClassSource>> methods = new ArrayList<MethodSource<JavaClassSource>>();
        MethodSource<JavaClassSource> method = CamelJavaParserHelper.findConfigureMethod(clazz);
        if (method != null) {
            methods.add(method);
        }
        if (includeInlinedRouteBuilders && !(inlinedMethods = CamelJavaParserHelper.findInlinedConfigureMethods(clazz)).isEmpty()) {
            methods.addAll(inlinedMethods);
        }
        CamelJavaRestDslParserHelper parser = new CamelJavaRestDslParserHelper();
        ArrayList<RestServiceDetails> list = new ArrayList<RestServiceDetails>();
        for (MethodSource methodSource : methods) {
            List<RestServiceDetails> details = parser.parseRestService(clazz, fullyQualifiedFileName, (MethodSource<JavaClassSource>)methodSource);
            list.addAll(details);
        }
        Collections.reverse(list);
        return list;
    }
}

