/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.parser.helper;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.parser.model.RestConfigurationDetails;
import org.apache.camel.parser.model.RestServiceDetails;
import org.apache.camel.parser.model.RestVerbDetails;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class CamelXmlRestDslParserHelper {
    public List<RestConfigurationDetails> parseRestConfiguration(Node xmlNode, String baseDir, String fullyQualifiedFileName) {
        ArrayList<RestConfigurationDetails> answer = new ArrayList<RestConfigurationDetails>();
        RestConfigurationDetails detail = new RestConfigurationDetails();
        detail.setFileName(fullyQualifiedFileName);
        this.walkXmlTree(xmlNode, detail);
        answer.add(detail);
        return answer;
    }

    public List<RestServiceDetails> parseRestService(Node xmlNode, String baseDir, String fullyQualifiedFileName) {
        ArrayList<RestServiceDetails> answer = new ArrayList<RestServiceDetails>();
        RestServiceDetails detail = new RestServiceDetails();
        detail.setFileName(fullyQualifiedFileName);
        this.walkXmlTree(xmlNode, detail);
        answer.add(detail);
        return answer;
    }

    private void walkXmlTree(Node xmlNode, RestConfigurationDetails detail) {
        String value;
        String key;
        NamedNodeMap map;
        if ("restConfiguration".equals(xmlNode.getNodeName())) {
            String lineNumber = (String)xmlNode.getUserData("lineNumber");
            String lineNumberEnd = (String)xmlNode.getUserData("lineNumberEnd");
            detail.setLineNumber(lineNumber);
            detail.setLineNumberEnd(lineNumberEnd);
            NamedNodeMap map2 = xmlNode.getAttributes();
            detail.setComponent(CamelXmlRestDslParserHelper.extractAttribute(map2, "component"));
            detail.setApiComponent(CamelXmlRestDslParserHelper.extractAttribute(map2, "apiComponent"));
            detail.setProducerComponent(CamelXmlRestDslParserHelper.extractAttribute(map2, "producerComponent"));
            detail.setScheme(CamelXmlRestDslParserHelper.extractAttribute(map2, "scheme"));
            detail.setHost(CamelXmlRestDslParserHelper.extractAttribute(map2, "host"));
            detail.setApiHost(CamelXmlRestDslParserHelper.extractAttribute(map2, "apiHost"));
            detail.setPort(CamelXmlRestDslParserHelper.extractAttribute(map2, "port"));
            detail.setProducerApiDoc(CamelXmlRestDslParserHelper.extractAttribute(map2, "producerApiDoc"));
            detail.setContextPath(CamelXmlRestDslParserHelper.extractAttribute(map2, "contextPath"));
            detail.setApiContextPath(CamelXmlRestDslParserHelper.extractAttribute(map2, "apiContextPath"));
            detail.setApiVendorExtension(CamelXmlRestDslParserHelper.extractAttribute(map2, "apiVendorExtension"));
            detail.setHostNameResolver(CamelXmlRestDslParserHelper.extractAttribute(map2, "hostNameResolver"));
            detail.setBindingMode(CamelXmlRestDslParserHelper.extractAttribute(map2, "bindingMode"));
            detail.setSkipBindingOnErrorCode(CamelXmlRestDslParserHelper.extractAttribute(map2, "skipBindingOnErrorCode"));
            detail.setClientRequestValidation(CamelXmlRestDslParserHelper.extractAttribute(map2, "clientRequestValidation"));
            detail.setEnableCORS(CamelXmlRestDslParserHelper.extractAttribute(map2, "enableCORS"));
            detail.setJsonDataFormat(CamelXmlRestDslParserHelper.extractAttribute(map2, "jsonDataFormat"));
            detail.setXmlDataFormat(CamelXmlRestDslParserHelper.extractAttribute(map2, "xmlDataFormat"));
        }
        if ("componentProperty".equals(xmlNode.getNodeName()) && xmlNode.getParentNode() != null && "restConfiguration".equals(xmlNode.getParentNode().getNodeName())) {
            map = xmlNode.getAttributes();
            key = CamelXmlRestDslParserHelper.extractAttribute(map, "key");
            value = CamelXmlRestDslParserHelper.extractAttribute(map, "value");
            if (key != null && value != null) {
                detail.addComponentProperty(key, value);
            }
        } else if ("endpointProperty".equals(xmlNode.getNodeName()) && xmlNode.getParentNode() != null && "restConfiguration".equals(xmlNode.getParentNode().getNodeName())) {
            map = xmlNode.getAttributes();
            key = CamelXmlRestDslParserHelper.extractAttribute(map, "key");
            value = CamelXmlRestDslParserHelper.extractAttribute(map, "value");
            if (key != null && value != null) {
                detail.addEndpointProperty(key, value);
            }
        } else if ("consumerProperty".equals(xmlNode.getNodeName()) && xmlNode.getParentNode() != null && "restConfiguration".equals(xmlNode.getParentNode().getNodeName())) {
            map = xmlNode.getAttributes();
            key = CamelXmlRestDslParserHelper.extractAttribute(map, "key");
            value = CamelXmlRestDslParserHelper.extractAttribute(map, "value");
            if (key != null && value != null) {
                detail.addConsumerProperty(key, value);
            }
        } else if ("dataFormatProperty".equals(xmlNode.getNodeName()) && xmlNode.getParentNode() != null && "restConfiguration".equals(xmlNode.getParentNode().getNodeName())) {
            map = xmlNode.getAttributes();
            key = CamelXmlRestDslParserHelper.extractAttribute(map, "key");
            value = CamelXmlRestDslParserHelper.extractAttribute(map, "value");
            if (key != null && value != null) {
                detail.addDataFormatProperty(key, value);
            }
        } else if ("apiProperty".equals(xmlNode.getNodeName()) && xmlNode.getParentNode() != null && "restConfiguration".equals(xmlNode.getParentNode().getNodeName())) {
            map = xmlNode.getAttributes();
            key = CamelXmlRestDslParserHelper.extractAttribute(map, "key");
            value = CamelXmlRestDslParserHelper.extractAttribute(map, "value");
            if (key != null && value != null) {
                detail.addApiProperty(key, value);
            }
        } else if ("corsHeaders".equals(xmlNode.getNodeName()) && xmlNode.getParentNode() != null && "restConfiguration".equals(xmlNode.getParentNode().getNodeName())) {
            map = xmlNode.getAttributes();
            key = CamelXmlRestDslParserHelper.extractAttribute(map, "key");
            value = CamelXmlRestDslParserHelper.extractAttribute(map, "value");
            if (key != null && value != null) {
                detail.addCorsHeader(key, value);
            }
        }
        NodeList children = xmlNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            this.walkXmlTree(child, detail);
        }
    }

    private void walkXmlTree(Node xmlNode, RestServiceDetails detail) {
        if ("rest".equals(xmlNode.getNodeName())) {
            String lineNumber = (String)xmlNode.getUserData("lineNumber");
            String lineNumberEnd = (String)xmlNode.getUserData("lineNumberEnd");
            detail.setLineNumber(lineNumber);
            detail.setLineNumberEnd(lineNumberEnd);
            CamelXmlRestDslParserHelper.extractAttributes(xmlNode, detail);
        }
        if (CamelXmlRestDslParserHelper.isParentRest(xmlNode)) {
            RestVerbDetails verb;
            if ("delete".equals(xmlNode.getNodeName())) {
                verb = new RestVerbDetails();
                verb.setMethod("delete");
                detail.addVerb(verb);
                CamelXmlRestDslParserHelper.extractAttributes(xmlNode, verb);
            } else if ("get".equals(xmlNode.getNodeName())) {
                verb = new RestVerbDetails();
                verb.setMethod("get");
                detail.addVerb(verb);
                CamelXmlRestDslParserHelper.extractAttributes(xmlNode, verb);
            } else if ("head".equals(xmlNode.getNodeName())) {
                verb = new RestVerbDetails();
                verb.setMethod("head");
                detail.addVerb(verb);
                CamelXmlRestDslParserHelper.extractAttributes(xmlNode, verb);
            } else if ("patch".equals(xmlNode.getNodeName())) {
                verb = new RestVerbDetails();
                verb.setMethod("patch");
                detail.addVerb(verb);
                CamelXmlRestDslParserHelper.extractAttributes(xmlNode, verb);
            } else if ("post".equals(xmlNode.getNodeName())) {
                verb = new RestVerbDetails();
                verb.setMethod("post");
                detail.addVerb(verb);
                CamelXmlRestDslParserHelper.extractAttributes(xmlNode, verb);
            } else if ("put".equals(xmlNode.getNodeName())) {
                verb = new RestVerbDetails();
                verb.setMethod("put");
                detail.addVerb(verb);
                CamelXmlRestDslParserHelper.extractAttributes(xmlNode, verb);
            }
            if ("description".equals(xmlNode.getNodeName())) {
                String value = xmlNode.getTextContent();
                RestVerbDetails verb2 = CamelXmlRestDslParserHelper.getLastVerb(detail);
                if (verb2 != null) {
                    verb2.setDescription(value);
                } else {
                    detail.setDescription(value);
                }
            } else if ("to".equals(xmlNode.getNodeName())) {
                NamedNodeMap map = xmlNode.getAttributes();
                String uri = CamelXmlRestDslParserHelper.extractAttribute(map, "uri");
                RestVerbDetails verb3 = CamelXmlRestDslParserHelper.getLastVerb(detail);
                if (verb3 != null) {
                    verb3.setTo(uri);
                }
            }
        }
        NodeList children = xmlNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            this.walkXmlTree(child, detail);
        }
    }

    private static void extractAttributes(Node xmlNode, RestServiceDetails detail) {
        NamedNodeMap map = xmlNode.getAttributes();
        detail.setConsumes(CamelXmlRestDslParserHelper.extractAttribute(map, "consumes"));
        detail.setProduces(CamelXmlRestDslParserHelper.extractAttribute(map, "produces"));
        detail.setApiDocs(CamelXmlRestDslParserHelper.extractAttribute(map, "apiDocs"));
        detail.setBindingMode(CamelXmlRestDslParserHelper.extractAttribute(map, "bindingMode"));
        detail.setClientRequestValidation(CamelXmlRestDslParserHelper.extractAttribute(map, "clientRequestValidation"));
        detail.setEnableCORS(CamelXmlRestDslParserHelper.extractAttribute(map, "enableCORS"));
        detail.setPath(CamelXmlRestDslParserHelper.extractAttribute(map, "path"));
        detail.setSkipBindingOnErrorCode(CamelXmlRestDslParserHelper.extractAttribute(map, "skipBindingOnErrorCode"));
        detail.setTag(CamelXmlRestDslParserHelper.extractAttribute(map, "tag"));
    }

    private static void extractAttributes(Node xmlNode, RestVerbDetails detail) {
        NamedNodeMap map = xmlNode.getAttributes();
        detail.setPath(CamelXmlRestDslParserHelper.extractAttribute(map, "path"));
        detail.setConsumes(CamelXmlRestDslParserHelper.extractAttribute(map, "consumes"));
        detail.setProduces(CamelXmlRestDslParserHelper.extractAttribute(map, "produces"));
        detail.setApiDocs(CamelXmlRestDslParserHelper.extractAttribute(map, "apiDocs"));
        detail.setBindingMode(CamelXmlRestDslParserHelper.extractAttribute(map, "bindingMode"));
        detail.setClientRequestValidation(CamelXmlRestDslParserHelper.extractAttribute(map, "clientRequestValidation"));
        detail.setSkipBindingOnErrorCode(CamelXmlRestDslParserHelper.extractAttribute(map, "skipBindingOnErrorCode"));
        detail.setType(CamelXmlRestDslParserHelper.extractAttribute(map, "type"));
        detail.setOutType(CamelXmlRestDslParserHelper.extractAttribute(map, "outType"));
    }

    private static RestVerbDetails getLastVerb(RestServiceDetails detail) {
        if (detail.getVerbs() == null) {
            return null;
        }
        return detail.getVerbs().get(detail.getVerbs().size() - 1);
    }

    private static boolean isParentRest(Node node) {
        if (node == null) {
            return false;
        }
        String name = node.getNodeName();
        if ("rest".equals(name)) {
            return true;
        }
        return CamelXmlRestDslParserHelper.isParentRest(node.getParentNode());
    }

    private static String extractAttribute(NamedNodeMap map, String name) {
        Node attr;
        if (map != null && (attr = map.getNamedItem(name)) != null) {
            return attr.getTextContent();
        }
        return null;
    }
}

