/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.parser.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.parser.ParserResult;
import org.apache.camel.parser.roaster.AnonymousMethodSource;
import org.apache.camel.parser.roaster.StatementFieldSource;
import org.apache.camel.tooling.util.Strings;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Block;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.BooleanLiteral;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Expression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ExpressionStatement;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.FieldDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.InfixExpression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MemberValuePair;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MethodDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MethodInvocation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.NormalAnnotation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.NumberLiteral;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.QualifiedName;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ReturnStatement;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SimpleName;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SimpleType;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Statement;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.StringLiteral;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Type;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.VariableDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public final class CamelJavaParserHelper {
    private CamelJavaParserHelper() {
    }

    public static MethodSource<JavaClassSource> findConfigureMethod(JavaClassSource clazz) {
        MethodSource<JavaClassSource> method = clazz.getMethod("configure");
        if (method != null && method.isPublic() && method.getParameters().isEmpty() && method.getReturnType().isType("void")) {
            return method;
        }
        method = CamelJavaParserHelper.findCreateRouteBuilderMethod(clazz);
        if (method != null) {
            return CamelJavaParserHelper.findConfigureMethodInCreateRouteBuilder(clazz, method);
        }
        return null;
    }

    public static List<MethodSource<JavaClassSource>> findInlinedConfigureMethods(JavaClassSource clazz) {
        ArrayList<MethodSource<JavaClassSource>> answer = new ArrayList<MethodSource<JavaClassSource>>();
        List methods = clazz.getMethods();
        if (methods != null) {
            for (MethodSource method : methods) {
                MethodSource<JavaClassSource> builder;
                if (!method.isPublic() || method.getParameters() != null && !method.getParameters().isEmpty() || method.getReturnType() != null && !method.getReturnType().isType("void") || (builder = CamelJavaParserHelper.findConfigureMethodInCreateRouteBuilder(clazz, (MethodSource<JavaClassSource>)method)) == null) continue;
                answer.add(builder);
            }
        }
        return answer;
    }

    private static MethodSource<JavaClassSource> findCreateRouteBuilderMethod(JavaClassSource clazz) {
        MethodSource method = clazz.getMethod("createRouteBuilder");
        if (method != null && (method.isPublic() || method.isProtected()) && method.getParameters().isEmpty()) {
            return method;
        }
        return null;
    }

    private static MethodSource<JavaClassSource> findConfigureMethodInCreateRouteBuilder(JavaClassSource clazz, MethodSource<JavaClassSource> method) {
        MethodDeclaration md = (MethodDeclaration)method.getInternal();
        Block block = md.getBody();
        if (block != null) {
            List statements = block.statements();
            for (Object statement : statements) {
                ExpressionStatement es;
                Statement stmt = (Statement)statement;
                Expression exp = null;
                if (stmt instanceof ReturnStatement) {
                    ReturnStatement rs = (ReturnStatement)stmt;
                    exp = rs.getExpression();
                } else if (stmt instanceof ExpressionStatement && (exp = (es = (ExpressionStatement)stmt).getExpression()) instanceof MethodInvocation) {
                    MethodInvocation mi = (MethodInvocation)exp;
                    for (Object arg : mi.arguments()) {
                        if (!(arg instanceof ClassInstanceCreation)) continue;
                        exp = (Expression)arg;
                        break;
                    }
                }
                if (!(exp instanceof ClassInstanceCreation)) continue;
                ClassInstanceCreation cic = (ClassInstanceCreation)exp;
                boolean isRouteBuilder = false;
                if (cic.getType() instanceof SimpleType) {
                    SimpleType st = (SimpleType)cic.getType();
                    isRouteBuilder = "RouteBuilder".equals(st.getName().toString());
                }
                if (!isRouteBuilder || cic.getAnonymousClassDeclaration() == null) continue;
                List body = cic.getAnonymousClassDeclaration().bodyDeclarations();
                for (Object line : body) {
                    MethodDeclaration amd;
                    if (!(line instanceof MethodDeclaration) || !"configure".equals((amd = (MethodDeclaration)line).getName().toString())) continue;
                    return new AnonymousMethodSource(clazz, amd);
                }
            }
        }
        return null;
    }

    public static List<ParserResult> parseCamelRouteIds(MethodSource<JavaClassSource> method) {
        return CamelJavaParserHelper.doParseCamelUris(method, true, false, true, false, true);
    }

    public static List<ParserResult> parseCamelConsumerUris(MethodSource<JavaClassSource> method, boolean strings, boolean fields) {
        return CamelJavaParserHelper.doParseCamelUris(method, true, false, strings, fields, false);
    }

    public static List<ParserResult> parseCamelProducerUris(MethodSource<JavaClassSource> method, boolean strings, boolean fields) {
        return CamelJavaParserHelper.doParseCamelUris(method, false, true, strings, fields, false);
    }

    private static List<ParserResult> doParseCamelUris(MethodSource<JavaClassSource> method, boolean consumers, boolean producers, boolean strings, boolean fields, boolean routeIdsOnly) {
        MethodDeclaration md;
        Block block;
        ArrayList<ParserResult> answer = new ArrayList<ParserResult>();
        if (method != null && (block = (md = (MethodDeclaration)method.getInternal()).getBody()) != null) {
            for (Object statement : md.getBody().statements()) {
                if (!(statement instanceof ExpressionStatement)) continue;
                ExpressionStatement es = (ExpressionStatement)statement;
                Expression exp = es.getExpression();
                ArrayList<ParserResult> uris = new ArrayList<ParserResult>();
                CamelJavaParserHelper.parseExpression((JavaClassSource)method.getOrigin(), block, exp, uris, consumers, producers, strings, fields, routeIdsOnly);
                if (uris.isEmpty()) continue;
                Collections.reverse(uris);
                answer.addAll(uris);
            }
        }
        return answer;
    }

    private static void parseExpression(JavaClassSource clazz, Block block, Expression exp, List<ParserResult> uris, boolean consumers, boolean producers, boolean strings, boolean fields, boolean routeIdsOnly) {
        if (exp == null) {
            return;
        }
        if (exp instanceof MethodInvocation) {
            MethodInvocation mi = (MethodInvocation)exp;
            CamelJavaParserHelper.doParseCamelUris(clazz, block, mi, uris, consumers, producers, strings, fields, routeIdsOnly);
            exp = mi.getExpression();
            CamelJavaParserHelper.parseExpression(clazz, block, exp, uris, consumers, producers, strings, fields, routeIdsOnly);
        }
    }

    private static void doParseCamelUris(JavaClassSource clazz, Block block, MethodInvocation mi, List<ParserResult> uris, boolean consumers, boolean producers, boolean strings, boolean fields, boolean routeIdsOnly) {
        Iterator arg;
        List args;
        String name = mi.getName().getIdentifier();
        if (routeIdsOnly) {
            List args2;
            if ("routeId".equals(name) && (args2 = mi.arguments()) != null) {
                for (Object arg2 : args2) {
                    String routeId;
                    if (!CamelJavaParserHelper.isValidArgument(name, arg2) || Strings.isNullOrEmpty((String)(routeId = CamelJavaParserHelper.getLiteralValue(clazz, block, (Expression)arg2)))) continue;
                    int position = ((Expression)arg2).getStartPosition();
                    int len = ((Expression)arg2).getLength();
                    uris.add(new ParserResult(name, position, len, routeId));
                }
            }
            return;
        }
        if (consumers) {
            if ("from".equals(name) && (args = mi.arguments()) != null) {
                for (Object arg3 : args) {
                    if (!CamelJavaParserHelper.isValidArgument(name, arg3)) continue;
                    CamelJavaParserHelper.extractEndpointUriFromArgument(name, clazz, block, uris, arg3, strings, fields);
                }
            }
            if ("fromF".equals(name) && (args = mi.arguments()) != null && !args.isEmpty() && CamelJavaParserHelper.isValidArgument(name, arg = args.get(0))) {
                CamelJavaParserHelper.extractEndpointUriFromArgument(name, clazz, block, uris, arg, strings, fields);
            }
            if ("interceptFrom".equals(name) && (args = mi.arguments()) != null && !args.isEmpty() && CamelJavaParserHelper.isValidArgument(name, arg = args.get(0))) {
                CamelJavaParserHelper.extractEndpointUriFromArgument(name, clazz, block, uris, arg, strings, fields);
            }
            if ("pollEnrich".equals(name) && (args = mi.arguments()) != null && !args.isEmpty() && CamelJavaParserHelper.isValidArgument(name, arg = args.get(0))) {
                CamelJavaParserHelper.extractEndpointUriFromArgument(name, clazz, block, uris, arg, strings, fields);
            }
        }
        if (producers) {
            if (("to".equals(name) || "toD".equals(name)) && (args = mi.arguments()) != null) {
                arg = args.iterator();
                while (arg.hasNext()) {
                    Object arg3;
                    arg3 = arg.next();
                    if (!CamelJavaParserHelper.isValidArgument(name, arg3)) continue;
                    CamelJavaParserHelper.extractEndpointUriFromArgument(name, clazz, block, uris, arg3, strings, fields);
                }
            }
            if ("toF".equals(name) && (args = mi.arguments()) != null && !args.isEmpty() && CamelJavaParserHelper.isValidArgument(name, arg = args.get(0))) {
                CamelJavaParserHelper.extractEndpointUriFromArgument(name, clazz, block, uris, arg, strings, fields);
            }
            if (("enrich".equals(name) || "wireTap".equals(name)) && (args = mi.arguments()) != null && !args.isEmpty() && CamelJavaParserHelper.isValidArgument(name, arg = args.get(0))) {
                CamelJavaParserHelper.extractEndpointUriFromArgument(name, clazz, block, uris, arg, strings, fields);
            }
        }
    }

    private static boolean isValidArgument(String node, Object arg) {
        QualifiedName qn;
        String name;
        if (arg instanceof BooleanLiteral) {
            return false;
        }
        return !(arg instanceof QualifiedName) || !(name = (qn = (QualifiedName)arg).getFullyQualifiedName()).startsWith("ExchangePattern");
    }

    private static void extractEndpointUriFromArgument(String node, JavaClassSource clazz, Block block, List<ParserResult> uris, Object arg, boolean strings, boolean fields) {
        FieldSource<JavaClassSource> field;
        String uri;
        if (strings && !Strings.isNullOrEmpty((String)(uri = CamelJavaParserHelper.getLiteralValue(clazz, block, (Expression)arg)))) {
            int position = ((Expression)arg).getStartPosition();
            int len = ((Expression)arg).getLength();
            if ("fromF".equals(node) || "toF".equals(node)) {
                uri = uri.replace("%s", "{{%s}}");
                uri = uri.replace("%d", "{{%d}}");
                uri = uri.replace("%b", "{{%b}}");
            }
            uris.add(new ParserResult(node, position, len, uri));
            return;
        }
        if (fields && arg instanceof SimpleName && (field = CamelJavaParserHelper.getField(clazz, block, (SimpleName)arg)) != null) {
            AnnotationSource annotation = field.getAnnotation("org.apache.camel.cdi.Uri");
            if (annotation == null) {
                annotation = field.getAnnotation("org.apache.camel.EndpointInject");
            }
            if (annotation != null) {
                Expression exp = (Expression)annotation.getInternal();
                if (exp instanceof SingleMemberAnnotation) {
                    exp = ((SingleMemberAnnotation)exp).getValue();
                } else if (exp instanceof NormalAnnotation) {
                    List values = ((NormalAnnotation)exp).values();
                    for (Object value : values) {
                        MemberValuePair pair = (MemberValuePair)value;
                        if (!"uri".equals(pair.getName().toString())) continue;
                        exp = pair.getValue();
                        break;
                    }
                }
                String uri2 = CamelJavaParserHelper.getLiteralValue(clazz, block, exp);
                if (!Strings.isNullOrEmpty((String)uri2)) {
                    int position = ((SimpleName)arg).getStartPosition();
                    int len = ((SimpleName)arg).getLength();
                    uris.add(new ParserResult(node, position, len, uri2));
                }
            } else {
                Expression exp;
                String uri3;
                Object fi = field.getInternal();
                if (fi instanceof VariableDeclaration && !Strings.isNullOrEmpty((String)(uri3 = CamelJavaParserHelper.getLiteralValue(clazz, block, exp = ((VariableDeclaration)fi).getInitializer())))) {
                    int position = ((VariableDeclaration)fi).getStartPosition();
                    int len = ((VariableDeclaration)fi).getLength();
                    uris.add(new ParserResult(node, position, len, uri3));
                }
            }
        }
        uris.add(new ParserResult(node, -1, -1, arg.toString(), false));
    }

    public static List<ParserResult> parseCamelLanguageExpressions(MethodSource<JavaClassSource> method, String language) {
        ArrayList<ParserResult> answer = new ArrayList<ParserResult>();
        MethodDeclaration md = (MethodDeclaration)method.getInternal();
        Block block = md.getBody();
        if (block != null) {
            for (Object statement : block.statements()) {
                if (!(statement instanceof ExpressionStatement)) continue;
                ExpressionStatement es = (ExpressionStatement)statement;
                Expression exp = es.getExpression();
                ArrayList<ParserResult> expressions = new ArrayList<ParserResult>();
                CamelJavaParserHelper.parseExpression(null, (JavaClassSource)method.getOrigin(), block, exp, expressions, language);
                if (expressions.isEmpty()) continue;
                Collections.reverse(expressions);
                answer.addAll(expressions);
            }
        }
        return answer;
    }

    private static void parseExpression(String node, JavaClassSource clazz, Block block, Expression exp, List<ParserResult> expressions, String language) {
        if (exp == null) {
            return;
        }
        if (exp instanceof MethodInvocation) {
            MethodInvocation mi = (MethodInvocation)exp;
            CamelJavaParserHelper.doParseCamelLanguage(node, clazz, block, mi, expressions, language);
            exp = mi.getExpression();
            CamelJavaParserHelper.parseExpression(node, clazz, block, exp, expressions, language);
        }
    }

    private static void doParseCamelLanguage(String node, JavaClassSource clazz, Block block, MethodInvocation mi, List<ParserResult> expressions, String language) {
        Object arg;
        String exp;
        List args;
        String name = mi.getName().getIdentifier();
        if (language.equals(name) && (args = mi.arguments()) != null && !args.isEmpty() && !Strings.isNullOrEmpty((String)(exp = CamelJavaParserHelper.getLiteralValue(clazz, block, (Expression)(arg = args.get(0)))))) {
            String pName;
            ASTNode o;
            ASTNode p;
            List list;
            boolean predicate = false;
            Expression parent = mi.getExpression();
            if (parent == null && (list = mi.arguments()) != null && list.size() == 1 && (p = (o = (ASTNode)list.get(0)).getParent()) instanceof MethodInvocation && language.equals(pName = ((MethodInvocation)p).getName().getIdentifier())) {
                parent = (Expression)p.getParent();
            }
            if (parent instanceof MethodInvocation) {
                MethodInvocation emi = (MethodInvocation)parent;
                String parentName = emi.getName().getIdentifier();
                predicate = CamelJavaParserHelper.isLanguagePredicate(parentName);
            }
            int position = ((Expression)arg).getStartPosition();
            int len = ((Expression)arg).getLength();
            ParserResult result = new ParserResult(node, position, len, exp);
            result.setPredicate(predicate);
            expressions.add(result);
        }
        if ((args = mi.arguments()) != null) {
            for (Object arg2 : args) {
                if (!(arg2 instanceof MethodInvocation)) continue;
                MethodInvocation ami = (MethodInvocation)arg2;
                CamelJavaParserHelper.doParseCamelLanguage(node, clazz, block, ami, expressions, language);
            }
        }
    }

    private static boolean isLanguagePredicate(String name) {
        if (name == null) {
            return false;
        }
        if (name.equals("completionPredicate") || name.equals("completion")) {
            return true;
        }
        if (name.equals("onWhen") || name.equals("when") || name.equals("handled") || name.equals("continued")) {
            return true;
        }
        return name.equals("retryWhile") || name.equals("filter") || name.equals("validate") || name.equals("loopDoWhile");
    }

    private static FieldSource<JavaClassSource> getField(JavaClassSource clazz, Block block, SimpleName ref) {
        String fieldName = ref.getIdentifier();
        if (fieldName != null) {
            FieldSource<JavaClassSource> field;
            FieldSource<JavaClassSource> fieldSource = field = clazz != null ? clazz.getField(fieldName) : null;
            if (field == null) {
                field = CamelJavaParserHelper.findFieldInBlock(clazz, block, fieldName);
            }
            return field;
        }
        return null;
    }

    private static FieldSource<JavaClassSource> findFieldInBlock(JavaClassSource clazz, Block block, String fieldName) {
        for (Object statement : block.statements()) {
            ASTNode node;
            if (statement instanceof VariableDeclarationStatement) {
                Type type = ((VariableDeclarationStatement)statement).getType();
                for (Object obj : ((VariableDeclarationStatement)statement).fragments()) {
                    VariableDeclarationFragment fragment;
                    SimpleName name;
                    if (!(obj instanceof VariableDeclarationFragment) || (name = (fragment = (VariableDeclarationFragment)obj).getName()) == null || !fieldName.equals(name.getIdentifier())) continue;
                    return new StatementFieldSource(clazz, fragment, type);
                }
            }
            if ((node = block.getParent()) instanceof MethodDeclaration) {
                node = node.getParent();
            }
            if (!(node instanceof AnonymousClassDeclaration)) continue;
            List declarations = ((AnonymousClassDeclaration)node).bodyDeclarations();
            for (Object dec : declarations) {
                if (!(dec instanceof FieldDeclaration)) continue;
                FieldDeclaration fd = (FieldDeclaration)dec;
                Type type = fd.getType();
                for (Object obj : fd.fragments()) {
                    VariableDeclarationFragment fragment;
                    SimpleName name;
                    if (!(obj instanceof VariableDeclarationFragment) || (name = (fragment = (VariableDeclarationFragment)obj).getName()) == null || !fieldName.equals(name.getIdentifier())) continue;
                    return new StatementFieldSource(clazz, fragment, type);
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getLiteralValue(JavaClassSource clazz, Block block, Expression expression) {
        boolean numeric;
        if (expression instanceof ParenthesizedExpression) {
            expression = ((ParenthesizedExpression)expression).getExpression();
        }
        if (expression instanceof StringLiteral) {
            return ((StringLiteral)expression).getLiteralValue();
        }
        if (expression instanceof BooleanLiteral) {
            return "" + ((BooleanLiteral)expression).booleanValue();
        }
        if (expression instanceof NumberLiteral) {
            return ((NumberLiteral)expression).getToken();
        }
        if (expression instanceof MethodInvocation) {
            String name = ((MethodInvocation)expression).getName().getIdentifier();
            return "{{" + name + "}}";
        }
        if (expression instanceof QualifiedName) {
            QualifiedName qn = (QualifiedName)expression;
            String name = qn.getFullyQualifiedName();
            return "{{" + name + "}}";
        }
        if (expression instanceof SimpleName) {
            FieldSource<JavaClassSource> field = CamelJavaParserHelper.getField(clazz, block, (SimpleName)expression);
            if (field != null) {
                VariableDeclarationFragment vdf;
                if (field.getAnnotations() != null) {
                    for (Annotation ann : field.getAnnotations()) {
                        boolean valid = "org.apache.camel.EndpointInject".equals(ann.getQualifiedName()) || "org.apache.camel.cdi.Uri".equals(ann.getQualifiedName());
                        if (!valid) continue;
                        Expression exp = (Expression)ann.getInternal();
                        if (exp instanceof SingleMemberAnnotation) {
                            exp = ((SingleMemberAnnotation)exp).getValue();
                        } else if (exp instanceof NormalAnnotation) {
                            List values = ((NormalAnnotation)exp).values();
                            for (Object value : values) {
                                MemberValuePair pair = (MemberValuePair)value;
                                if (!"uri".equals(pair.getName().toString())) continue;
                                exp = pair.getValue();
                                break;
                            }
                        }
                        if (exp == null) continue;
                        return CamelJavaParserHelper.getLiteralValue(clazz, block, exp);
                    }
                }
                if ("Endpoint".equals(field.getType().getSimpleName())) {
                    vdf = (VariableDeclarationFragment)field.getInternal();
                    expression = vdf.getInitializer();
                    if (!(expression instanceof MethodInvocation)) return null;
                    MethodInvocation mi = (MethodInvocation)expression;
                    List args = mi.arguments();
                    if (args == null) return null;
                    if (args.isEmpty()) return null;
                    expression = (Expression)args.get(0);
                    return CamelJavaParserHelper.getLiteralValue(clazz, block, expression);
                }
                vdf = (VariableDeclarationFragment)field.getInternal();
                expression = vdf.getInitializer();
                if (expression != null) return CamelJavaParserHelper.getLiteralValue(clazz, block, expression);
                return "{{" + field.getName() + "}}";
            }
            String fieldName = ((SimpleName)expression).getIdentifier();
            return "{{" + fieldName + "}}";
        }
        if (!(expression instanceof InfixExpression)) return null;
        Object answer = null;
        InfixExpression ie = (InfixExpression)expression;
        if (!InfixExpression.Operator.PLUS.equals(ie.getOperator())) return answer;
        String val1 = CamelJavaParserHelper.getLiteralValue(clazz, block, ie.getLeftOperand());
        String val2 = CamelJavaParserHelper.getLiteralValue(clazz, block, ie.getRightOperand());
        boolean bl = numeric = CamelJavaParserHelper.isNumericOperator(clazz, block, ie.getLeftOperand()) && CamelJavaParserHelper.isNumericOperator(clazz, block, ie.getRightOperand());
        if (numeric) {
            long num1 = val1 != null ? Long.parseLong(val1) : 0L;
            long num2 = val2 != null ? Long.parseLong(val2) : 0L;
            answer = Long.toString(num1 + num2);
        } else {
            answer = (val1 != null ? val1 : "") + (val2 != null ? val2 : "");
        }
        if (((String)answer).isEmpty()) return answer;
        List extended = ie.extendedOperands();
        if (extended == null) return answer;
        StringBuilder answerBuilder = new StringBuilder((String)answer);
        Iterator iterator = extended.iterator();
        while (iterator.hasNext()) {
            Object ext = iterator.next();
            String val3 = CamelJavaParserHelper.getLiteralValue(clazz, block, (Expression)ext);
            if (numeric) {
                long num3 = val3 != null ? Long.parseLong(val3) : 0L;
                long num = Long.parseLong(answerBuilder.toString());
                answerBuilder = new StringBuilder(Long.toString(num + num3));
                continue;
            }
            answerBuilder.append(val3 != null ? val3 : "");
        }
        return answerBuilder.toString();
    }

    private static boolean isNumericOperator(JavaClassSource clazz, Block block, Expression expression) {
        FieldSource<JavaClassSource> field;
        if (expression instanceof NumberLiteral) {
            return true;
        }
        if (expression instanceof SimpleName && (field = CamelJavaParserHelper.getField(clazz, block, (SimpleName)expression)) != null) {
            return field.getType().isType("int") || field.getType().isType("long") || field.getType().isType("Integer") || field.getType().isType("Long");
        }
        return false;
    }
}

