/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.generator.openapi;

import io.apicurio.datamodels.models.openapi.OpenApiDocument;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.camel.generator.openapi.DestinationGenerator;
import org.apache.camel.generator.openapi.RestDslGenerator;
import org.apache.camel.generator.openapi.RestDslSourceCodeGenerator;
import org.apache.camel.maven.generator.openapi.AbstractGenerateMojo;
import org.apache.camel.util.ObjectHelper;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="generate", inheritByDefault=false, defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class GenerateMojo
extends AbstractGenerateMojo {
    @Parameter
    private String className;
    @Parameter
    private String indent;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/restdsl-openapi", required=true)
    private String outputDirectory;
    @Parameter
    private String packageName;

    public void execute() throws MojoExecutionException {
        OpenApiDocument openapi;
        if (this.skip) {
            return;
        }
        try {
            openapi = this.readOpenApiDoc(this.specificationUri);
        }
        catch (Exception e1) {
            throw new MojoExecutionException("can't load open api doc from " + this.specificationUri, e1);
        }
        if (openapi == null) {
            throw new MojoExecutionException("Unable to generate REST DSL OpenApi sources from specification: " + this.specificationUri + ", make sure that the specification is available at the given URI");
        }
        RestDslSourceCodeGenerator generator = RestDslGenerator.toPath((OpenApiDocument)openapi);
        if (ObjectHelper.isNotEmpty((String)this.filterOperation)) {
            generator.withOperationFilter(this.filterOperation);
        }
        if (ObjectHelper.isNotEmpty((String)this.className)) {
            generator.withClassName(this.className);
        }
        if (this.indent != null) {
            generator.withIndent(this.indent.replace("\\t", "\t"));
        }
        if (ObjectHelper.isNotEmpty((String)this.basePath)) {
            generator.withBasePath(this.basePath);
        }
        if (ObjectHelper.isNotEmpty((String)this.packageName)) {
            generator.withPackageName(this.packageName);
        }
        if (ObjectHelper.isNotEmpty((String)this.destinationGenerator)) {
            DestinationGenerator destinationGeneratorObject = this.createDestinationGenerator();
            generator.withDestinationGenerator(destinationGeneratorObject);
        } else if (ObjectHelper.isNotEmpty((String)this.destinationToSyntax)) {
            generator.withDestinationToSyntax(this.destinationToSyntax);
        }
        Path outputPath = new File(this.outputDirectory).toPath();
        if (this.restConfiguration) {
            String comp = this.findAppropriateComponent();
            generator.withRestComponent(comp);
            if (this.clientRequestValidation) {
                generator.withClientRequestValidation();
            }
            if (ObjectHelper.isNotEmpty((String)this.apiContextPath)) {
                generator.withApiContextPath(this.apiContextPath);
            }
        }
        if (this.detectSpringBootFromClasspath()) {
            generator.asSpringComponent();
            generator.asSpringBootProject();
            if (ObjectHelper.isEmpty((String)this.packageName)) {
                try {
                    String sbPackage = this.detectSpringBootMainPackage();
                    if (sbPackage != null) {
                        generator.withPackageName(sbPackage);
                    }
                }
                catch (IOException sbPackage) {
                    // empty catch block
                }
            }
        }
        try {
            this.getLog().info((CharSequence)("Generating Camel DSL source in directory: " + String.valueOf(outputPath)));
            generator.generate((Object)outputPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to generate REST DSL OpenApi sources from specification: " + this.specificationUri, (Exception)e);
        }
        if (ObjectHelper.isNotEmpty((String)this.modelOutput)) {
            this.project.addCompileSourceRoot(this.modelOutput);
        }
        if (ObjectHelper.isNotEmpty((String)this.outputDirectory)) {
            this.project.addCompileSourceRoot(this.outputDirectory);
        }
    }
}

